/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreStub;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CompositeReadOnlyWindowStoreTest {
    private static final long WINDOW_SIZE = 30000L;
    private final String storeName = "window-store";
    private StateStoreProviderStub stubProviderOne;
    private StateStoreProviderStub stubProviderTwo;
    private CompositeReadOnlyWindowStore<String, String> windowStore;
    private ReadOnlyWindowStoreStub<String, String> underlyingWindowStore;
    private ReadOnlyWindowStoreStub<String, String> otherUnderlyingStore;
    @Rule
    public final ExpectedException windowStoreIteratorException = ExpectedException.none();

    @Before
    public void before() {
        this.stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.underlyingWindowStore = new ReadOnlyWindowStoreStub(30000L);
        this.stubProviderOne.addStore("window-store", this.underlyingWindowStore);
        this.otherUnderlyingStore = new ReadOnlyWindowStoreStub(30000L);
        this.stubProviderOne.addStore("other-window-store", this.otherUnderlyingStore);
        this.windowStore = new CompositeReadOnlyWindowStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(this.stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.windowStore(), "window-store");
    }

    @Test
    public void shouldFetchValuesFromWindowStore() throws Exception {
        this.underlyingWindowStore.put("my-key", "my-value", 0L);
        this.underlyingWindowStore.put("my-key", "my-later-value", 10L);
        WindowStoreIterator iterator = this.windowStore.fetch((Object)"my-key", 0L, 25L);
        List results = StreamsTestUtils.toList(iterator);
        Assert.assertEquals(Arrays.asList(new KeyValue((Object)0L, (Object)"my-value"), new KeyValue((Object)10L, (Object)"my-later-value")), results);
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() throws Exception {
        WindowStoreIterator iterator = this.windowStore.fetch((Object)"my-key", 0L, 25L);
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() throws Exception {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("key-one", "value-one", 0L);
        secondUnderlying.put("key-two", "value-two", 10L);
        List keyOneResults = StreamsTestUtils.toList(this.windowStore.fetch((Object)"key-one", 0L, 1L));
        List keyTwoResults = StreamsTestUtils.toList(this.windowStore.fetch((Object)"key-two", 10L, 11L));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)0L, (Object)"value-one")), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)10L, (Object)"value-two")), keyTwoResults);
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() throws Exception {
        this.otherUnderlyingStore.put("some-key", "some-value", 0L);
        this.underlyingWindowStore.put("some-key", "my-value", 1L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch((Object)"some-key", 0L, 2L));
        Assert.assertEquals(Collections.singletonList(new KeyValue((Object)1L, (Object)"my-value")), results);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() throws Exception {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new StateStoreProviderStub(true), QueryableStoreTypes.windowStore(), "foo");
        store.fetch((Object)"key", 1L, 10L);
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfFetchThrows() throws Exception {
        this.underlyingWindowStore.setOpen(false);
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)this.stubProviderOne, QueryableStoreTypes.windowStore(), "window-store");
        try {
            store.fetch((Object)"key", 1L, 10L);
            Assert.fail((String)"InvalidStateStoreException was expected");
        }
        catch (InvalidStateStoreException e) {
            Assert.assertEquals((Object)"State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", (Object)e.getMessage());
        }
    }

    @Test
    public void emptyIteratorAlwaysReturnsFalse() throws Exception {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new StateStoreProviderStub(false), QueryableStoreTypes.windowStore(), "foo");
        WindowStoreIterator windowStoreIterator = store.fetch((Object)"key", 1L, 10L);
        Assert.assertFalse((boolean)windowStoreIterator.hasNext());
    }

    @Test
    public void emptyIteratorPeekNextKeyShouldThrowNoSuchElementException() throws Exception {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new StateStoreProviderStub(false), QueryableStoreTypes.windowStore(), "foo");
        WindowStoreIterator windowStoreIterator = store.fetch((Object)"key", 1L, 10L);
        this.windowStoreIteratorException.expect(NoSuchElementException.class);
        windowStoreIterator.peekNextKey();
    }

    @Test
    public void emptyIteratorNextShouldThrowNoSuchElementException() throws Exception {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new StateStoreProviderStub(false), QueryableStoreTypes.windowStore(), "foo");
        WindowStoreIterator windowStoreIterator = store.fetch((Object)"key", 1L, 10L);
        this.windowStoreIteratorException.expect(NoSuchElementException.class);
        windowStoreIterator.next();
    }
}

