/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ClientStateTest {
    private final ClientState client = new ClientState(1);

    @Test
    public void shouldHaveNotReachedCapacityWhenAssignedTasksLessThanCapacity() throws Exception {
        Assert.assertFalse((boolean)this.client.reachedCapacity());
    }

    @Test
    public void shouldHaveReachedCapacityWhenAssignedTasksGreaterThanOrEqualToCapacity() throws Exception {
        this.client.assign(new TaskId(0, 1), true);
        Assert.assertTrue((boolean)this.client.reachedCapacity());
    }

    @Test
    public void shouldAddActiveTasksToBothAssignedAndActive() throws Exception {
        TaskId tid = new TaskId(0, 1);
        this.client.assign(tid, true);
        MatcherAssert.assertThat((Object)this.client.activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(tid)));
        MatcherAssert.assertThat((Object)this.client.assignedTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(tid)));
        MatcherAssert.assertThat((Object)this.client.assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.client.standbyTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldAddStandbyTasksToBothStandbyAndActive() throws Exception {
        TaskId tid = new TaskId(0, 1);
        this.client.assign(tid, false);
        MatcherAssert.assertThat((Object)this.client.assignedTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(tid)));
        MatcherAssert.assertThat((Object)this.client.standbyTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(tid)));
        MatcherAssert.assertThat((Object)this.client.assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.client.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldAddPreviousActiveTasksToPreviousAssignedAndPreviousActive() throws Exception {
        TaskId tid1 = new TaskId(0, 1);
        TaskId tid2 = new TaskId(0, 2);
        this.client.addPreviousActiveTasks(Utils.mkSet((Object[])new TaskId[]{tid1, tid2}));
        MatcherAssert.assertThat((Object)this.client.previousActiveTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{tid1, tid2})));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{tid1, tid2})));
    }

    @Test
    public void shouldAddPreviousStandbyTasksToPreviousAssigned() throws Exception {
        TaskId tid1 = new TaskId(0, 1);
        TaskId tid2 = new TaskId(0, 2);
        this.client.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{tid1, tid2}));
        MatcherAssert.assertThat((Object)this.client.previousActiveTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{tid1, tid2})));
    }

    @Test
    public void shouldHaveAssignedTaskIfActiveTaskAssigned() throws Exception {
        TaskId tid = new TaskId(0, 2);
        this.client.assign(tid, true);
        Assert.assertTrue((boolean)this.client.hasAssignedTask(tid));
    }

    @Test
    public void shouldHaveAssignedTaskIfStandbyTaskAssigned() throws Exception {
        TaskId tid = new TaskId(0, 2);
        this.client.assign(tid, false);
        Assert.assertTrue((boolean)this.client.hasAssignedTask(tid));
    }

    @Test
    public void shouldNotHaveAssignedTaskIfTaskNotAssigned() throws Exception {
        this.client.assign(new TaskId(0, 2), true);
        Assert.assertFalse((boolean)this.client.hasAssignedTask(new TaskId(0, 3)));
    }

    @Test
    public void shouldHaveMoreAvailableCapacityWhenCapacityTheSameButFewerAssignedTasks() throws Exception {
        ClientState c2 = new ClientState(1);
        this.client.assign(new TaskId(0, 1), true);
        Assert.assertTrue((boolean)c2.hasMoreAvailableCapacityThan(this.client));
        Assert.assertFalse((boolean)this.client.hasMoreAvailableCapacityThan(c2));
    }

    @Test
    public void shouldHaveMoreAvailableCapacityWhenCapacityHigherAndSameAssignedTaskCount() throws Exception {
        ClientState c2 = new ClientState(2);
        Assert.assertTrue((boolean)c2.hasMoreAvailableCapacityThan(this.client));
        Assert.assertFalse((boolean)this.client.hasMoreAvailableCapacityThan(c2));
    }

    @Test
    public void shouldUseMultiplesOfCapacityToDetermineClientWithMoreAvailableCapacity() throws Exception {
        int i;
        ClientState c2 = new ClientState(2);
        for (i = 0; i < 7; ++i) {
            c2.assign(new TaskId(0, i), true);
        }
        for (i = 7; i < 11; ++i) {
            this.client.assign(new TaskId(0, i), true);
        }
        Assert.assertTrue((boolean)c2.hasMoreAvailableCapacityThan(this.client));
    }

    @Test
    public void shouldHaveMoreAvailableCapacityWhenCapacityIsTheSameButAssignedTasksIsLess() throws Exception {
        ClientState c1 = new ClientState(3);
        ClientState c2 = new ClientState(3);
        for (int i = 0; i < 4; ++i) {
            c1.assign(new TaskId(0, i), true);
            c2.assign(new TaskId(0, i), true);
        }
        c2.assign(new TaskId(0, 5), true);
        Assert.assertTrue((boolean)c1.hasMoreAvailableCapacityThan(c2));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateExceptionIfCapacityOfThisClientStateIsZero() throws Exception {
        ClientState c1 = new ClientState(0);
        c1.hasMoreAvailableCapacityThan(new ClientState(1));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateExceptionIfCapacityOfOtherClientStateIsZero() throws Exception {
        ClientState c1 = new ClientState(1);
        c1.hasMoreAvailableCapacityThan(new ClientState(0));
    }

    @Test
    public void shouldHaveUnfulfilledQuotaWhenActiveTaskSizeLessThanCapacityTimesTasksPerThread() throws Exception {
        ClientState client = new ClientState(1);
        client.assign(new TaskId(0, 1), true);
        Assert.assertTrue((boolean)client.hasUnfulfilledQuota(2));
    }

    @Test
    public void shouldNotHaveUnfulfilledQuotaWhenActiveTaskSizeGreaterEqualThanCapacityTimesTasksPerThread() throws Exception {
        ClientState client = new ClientState(1);
        client.assign(new TaskId(0, 1), true);
        Assert.assertFalse((boolean)client.hasUnfulfilledQuota(1));
    }
}

