/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockKeyValueMapper;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KGroupedTableImplTest {
    private final KStreamBuilder builder = new KStreamBuilder();
    private static final String INVALID_STORE_NAME = "~foo bar~";
    private KGroupedTable<String, String> groupedTable;
    private KStreamTestDriver driver = null;

    @Before
    public void before() {
        this.groupedTable = this.builder.table(Serdes.String(), Serdes.String(), "blah", "blah").groupBy(MockKeyValueMapper.SelectValueKeyValueMapper());
    }

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void shouldAllowNullStoreNameOnCount() {
        this.groupedTable.count((String)null);
    }

    @Test
    public void shouldAllowNullStoreNameOnAggregate() throws Exception {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, (String)null);
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldNotAllowInvalidStoreNameOnAggregate() throws Exception {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, INVALID_STORE_NAME);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInitializerOnAggregate() throws Exception {
        this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullAdderOnAggregate() throws Exception {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSubtractorOnAggregate() throws Exception {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullAdderOnReduce() throws Exception {
        this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSubtractorOnReduce() throws Exception {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, null, "store");
    }

    @Test
    public void shouldAllowNullStoreNameOnReduce() throws Exception {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, (String)null);
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldNotAllowInvalidStoreNameOnReduce() throws Exception {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, INVALID_STORE_NAME);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullStoreSupplierOnReduce() throws Exception {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, (StateStoreSupplier)null);
    }

    private void doShouldReduce(KTable<String, Integer> reduced, String topic) throws Exception {
        final HashMap results = new HashMap();
        reduced.foreach((ForeachAction)new ForeachAction<String, Integer>(){

            public void apply(String key, Integer value) {
                results.put(key, value);
            }
        });
        this.driver = new KStreamTestDriver(this.builder, TestUtils.tempDirectory(), Serdes.String(), Serdes.Integer());
        this.driver.setTime(10L);
        this.driver.process(topic, "A", 1.1);
        this.driver.process(topic, "B", 2.2);
        this.driver.flushState();
        Assert.assertEquals((Object)1, results.get("A"));
        Assert.assertEquals((Object)2, results.get("B"));
        this.driver.process(topic, "A", 2.6);
        this.driver.process(topic, "B", 1.3);
        this.driver.process(topic, "A", 5.7);
        this.driver.process(topic, "B", 6.2);
        this.driver.flushState();
        Assert.assertEquals((Object)5, results.get("A"));
        Assert.assertEquals((Object)6, results.get("B"));
    }

    @Test
    public void shouldReduce() throws Exception {
        String topic = "input";
        KeyValueMapper<String, Number, KeyValue<String, Integer>> intProjection = new KeyValueMapper<String, Number, KeyValue<String, Integer>>(){

            public KeyValue<String, Integer> apply(String key, Number value) {
                return KeyValue.pair((Object)key, (Object)value.intValue());
            }
        };
        KTable reduced = this.builder.table(Serdes.String(), Serdes.Double(), "input", "store").groupBy((KeyValueMapper)intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, "reduced");
        this.doShouldReduce((KTable<String, Integer>)reduced, "input");
        Assert.assertEquals((Object)reduced.queryableStoreName(), (Object)"reduced");
    }

    @Test
    public void shouldReduceWithInternalStoreName() throws Exception {
        String topic = "input";
        KeyValueMapper<String, Number, KeyValue<String, Integer>> intProjection = new KeyValueMapper<String, Number, KeyValue<String, Integer>>(){

            public KeyValue<String, Integer> apply(String key, Number value) {
                return KeyValue.pair((Object)key, (Object)value.intValue());
            }
        };
        KTable reduced = this.builder.table(Serdes.String(), Serdes.Double(), "input", "store").groupBy((KeyValueMapper)intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR);
        this.doShouldReduce((KTable<String, Integer>)reduced, "input");
        Assert.assertNull((Object)reduced.queryableStoreName());
    }
}

