/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.utils.MockTime;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class GlobalKTableIntegrationTest {
    private static final int NUM_BROKERS = 1;
    private static final Properties BROKER_CONFIG = new Properties();
    @ClassRule
    public static final EmbeddedKafkaCluster CLUSTER;
    private static volatile int testNo;
    private final MockTime mockTime;
    private final KeyValueMapper<String, Long, Long> keyMapper;
    private final ValueJoiner<Long, String, String> joiner;
    private KStreamBuilder builder;
    private Properties streamsConfiguration;
    private KafkaStreams kafkaStreams;
    private String globalOne;
    private String inputStream;
    private String inputTable;
    private final String globalStore = "globalStore";
    private GlobalKTable<Long, String> globalTable;
    private KStream<String, Long> stream;
    private KTable<String, Long> table;
    final Map<String, String> results;
    private ForeachAction<String, String> foreachAction;

    public GlobalKTableIntegrationTest() {
        this.mockTime = GlobalKTableIntegrationTest.CLUSTER.time;
        this.keyMapper = new KeyValueMapper<String, Long, Long>(){

            public Long apply(String key, Long value) {
                return value;
            }
        };
        this.joiner = new ValueJoiner<Long, String, String>(){

            public String apply(Long value1, String value2) {
                return value1 + "+" + value2;
            }
        };
        this.globalStore = "globalStore";
        this.results = new HashMap<String, String>();
    }

    @Before
    public void before() throws InterruptedException {
        this.builder = new KStreamBuilder();
        this.createTopics();
        this.streamsConfiguration = new Properties();
        String applicationId = "globalOne-table-test-" + ++testNo;
        this.streamsConfiguration.put("application.id", applicationId);
        this.streamsConfiguration.put("bootstrap.servers", CLUSTER.bootstrapServers());
        this.streamsConfiguration.put("auto.offset.reset", "earliest");
        this.streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        this.streamsConfiguration.put("cache.max.bytes.buffering", (Object)0);
        this.streamsConfiguration.put("internal.leave.group.on.close", (Object)true);
        this.streamsConfiguration.put("commit.interval.ms", (Object)100);
        this.globalTable = this.builder.globalTable(Serdes.Long(), Serdes.String(), null, this.globalOne, "globalStore");
        this.stream = this.builder.stream(Serdes.String(), Serdes.Long(), new String[]{this.inputStream});
        this.table = this.builder.table(Serdes.String(), Serdes.Long(), this.inputTable, "table");
        this.foreachAction = new ForeachAction<String, String>(){

            public void apply(String key, String value) {
                GlobalKTableIntegrationTest.this.results.put(key, value);
            }
        };
    }

    @After
    public void whenShuttingDown() throws IOException {
        if (this.kafkaStreams != null) {
            this.kafkaStreams.close();
        }
        IntegrationTestUtils.purgeLocalStreamsState(this.streamsConfiguration);
    }

    @Test
    public void shouldKStreamGlobalKTableLeftJoin() throws Exception {
        KStream streamTableJoin = this.stream.leftJoin(this.globalTable, this.keyMapper, this.joiner);
        streamTableJoin.foreach(this.foreachAction);
        this.produceInitialGlobalTableValues();
        this.startStreams();
        this.produceTopicValues(this.inputStream);
        final HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "1+A");
        expected.put("b", "2+B");
        expected.put("c", "3+C");
        expected.put("d", "4+D");
        expected.put("e", "5+null");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for initial values");
        this.produceGlobalTableValues();
        final ReadOnlyKeyValueStore replicatedStore = (ReadOnlyKeyValueStore)this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return "J".equals(replicatedStore.get((Object)5L));
            }
        }, (long)30000L, (String)"waiting for data in replicated store");
        this.produceTopicValues(this.inputStream);
        expected.put("a", "1+F");
        expected.put("b", "2+G");
        expected.put("c", "3+H");
        expected.put("d", "4+I");
        expected.put("e", "5+J");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for final values");
    }

    @Test
    public void shouldKStreamGlobalKTableJoin() throws Exception {
        KStream streamTableJoin = this.stream.join(this.globalTable, this.keyMapper, this.joiner);
        streamTableJoin.foreach(this.foreachAction);
        this.produceInitialGlobalTableValues();
        this.startStreams();
        this.produceTopicValues(this.inputStream);
        final HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "1+A");
        expected.put("b", "2+B");
        expected.put("c", "3+C");
        expected.put("d", "4+D");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for initial values");
        this.produceGlobalTableValues();
        final ReadOnlyKeyValueStore replicatedStore = (ReadOnlyKeyValueStore)this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return "J".equals(replicatedStore.get((Object)5L));
            }
        }, (long)30000L, (String)"waiting for data in replicated store");
        this.produceTopicValues(this.inputStream);
        expected.put("a", "1+F");
        expected.put("b", "2+G");
        expected.put("c", "3+H");
        expected.put("d", "4+I");
        expected.put("e", "5+J");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for final values");
    }

    @Test
    public void shouldRestoreTransactionalMessages() throws Exception {
        this.produceInitialGlobalTableValues(true);
        this.startStreams();
        final HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(1L, "A");
        expected.put(2L, "B");
        expected.put(3L, "C");
        expected.put(4L, "D");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                ReadOnlyKeyValueStore store = null;
                try {
                    store = (ReadOnlyKeyValueStore)GlobalKTableIntegrationTest.this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
                }
                catch (InvalidStateStoreException ex) {
                    return false;
                }
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                KeyValueIterator it = store.all();
                while (it.hasNext()) {
                    KeyValue kv = (KeyValue)it.next();
                    result.put(kv.key, kv.value);
                }
                return result.equals(expected);
            }
        }, (long)30000L, (String)"waiting for initial values");
        System.out.println("no failed test");
    }

    private void createTopics() throws InterruptedException {
        this.inputStream = "input-stream-" + testNo;
        this.inputTable = "input-table-" + testNo;
        this.globalOne = "globalOne-" + testNo;
        CLUSTER.createTopics(this.inputStream, this.inputTable);
        CLUSTER.createTopic(this.globalOne, 2, 1);
    }

    private void startStreams() {
        this.kafkaStreams = new KafkaStreams((TopologyBuilder)this.builder, this.streamsConfiguration);
        this.kafkaStreams.start();
    }

    private void produceTopicValues(String topic) throws ExecutionException, InterruptedException {
        IntegrationTestUtils.produceKeyValuesSynchronously(topic, Arrays.asList(new KeyValue((Object)"a", (Object)1L), new KeyValue((Object)"b", (Object)2L), new KeyValue((Object)"c", (Object)3L), new KeyValue((Object)"d", (Object)4L), new KeyValue((Object)"e", (Object)5L)), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), StringSerializer.class, LongSerializer.class, (Properties)new Properties()), (Time)this.mockTime);
    }

    private void produceInitialGlobalTableValues() throws ExecutionException, InterruptedException {
        this.produceInitialGlobalTableValues(false);
    }

    private void produceInitialGlobalTableValues(boolean enableTransactions) throws ExecutionException, InterruptedException {
        Properties properties = new Properties();
        if (enableTransactions) {
            properties.put("transactional.id", "someid");
            properties.put("retries", (Object)1);
        }
        IntegrationTestUtils.produceKeyValuesSynchronously(this.globalOne, Arrays.asList(new KeyValue((Object)1L, (Object)"A"), new KeyValue((Object)2L, (Object)"B"), new KeyValue((Object)3L, (Object)"C"), new KeyValue((Object)4L, (Object)"D")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), LongSerializer.class, StringSerializer.class, (Properties)properties), (Time)this.mockTime, enableTransactions);
    }

    private void produceGlobalTableValues() throws ExecutionException, InterruptedException {
        IntegrationTestUtils.produceKeyValuesSynchronously(this.globalOne, Arrays.asList(new KeyValue((Object)1L, (Object)"F"), new KeyValue((Object)2L, (Object)"G"), new KeyValue((Object)3L, (Object)"H"), new KeyValue((Object)4L, (Object)"I"), new KeyValue((Object)5L, (Object)"J")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), LongSerializer.class, StringSerializer.class, (Properties)new Properties()), (Time)this.mockTime);
    }

    static {
        BROKER_CONFIG.put("transaction.state.log.replication.factor", (Object)1);
        BROKER_CONFIG.put("transaction.state.log.min.isr", (Object)1);
        CLUSTER = new EmbeddedKafkaCluster(1, BROKER_CONFIG);
        testNo = 0;
    }
}

