/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class MergedSortedCacheWindowStoreIterator<V>
extends AbstractMergedSortedCacheStoreIterator<Long, Long, V>
implements WindowStoreIterator<V> {
    MergedSortedCacheWindowStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Long, byte[]> storeIterator, StateSerdes<Long, V> serdes) {
        super(cacheIterator, storeIterator, serdes);
    }

    @Override
    public KeyValue<Long, V> deserializeStorePair(KeyValue<Long, byte[]> pair) {
        return KeyValue.pair(pair.key, this.serdes.valueFrom((byte[])pair.value));
    }

    @Override
    Long deserializeCacheKey(Bytes cacheKey) {
        return WindowStoreUtils.timestampFromBinaryKey(cacheKey.get());
    }

    @Override
    public Long deserializeStoreKey(Long key) {
        return key;
    }

    @Override
    public int compare(Bytes cacheKey, Long storeKey) {
        Long cacheTimestamp = WindowStoreUtils.timestampFromBinaryKey(cacheKey.get());
        return cacheTimestamp.compareTo(storeKey);
    }
}

