/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

class MergedSortedCacheSessionStoreIterator<K, AGG>
extends AbstractMergedSortedCacheStoreIterator<Windowed<K>, Windowed<Bytes>, AGG> {
    private final StateSerdes<K, AGG> rawSerdes;

    MergedSortedCacheSessionStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator, StateSerdes<K, AGG> serdes) {
        super(cacheIterator, storeIterator, new StateSerdes<K, AGG>(serdes.topic(), new SessionKeySerde<K>(serdes.keySerde()), serdes.valueSerde()));
        this.rawSerdes = serdes;
    }

    @Override
    public KeyValue<Windowed<K>, AGG> deserializeStorePair(KeyValue<Windowed<Bytes>, byte[]> pair) {
        K key = this.rawSerdes.keyFrom(((Bytes)((Windowed)pair.key).key()).get());
        return KeyValue.pair(new Windowed<K>(key, ((Windowed)pair.key).window()), this.serdes.valueFrom((byte[])pair.value));
    }

    @Override
    Windowed<K> deserializeCacheKey(Bytes cacheKey) {
        return SessionKeySerde.from(cacheKey.get(), this.rawSerdes.keyDeserializer(), this.rawSerdes.topic());
    }

    @Override
    public Windowed<K> deserializeStoreKey(Windowed<Bytes> key) {
        K originalKey = this.rawSerdes.keyFrom(key.key().get());
        return new Windowed<K>(originalKey, key.window());
    }

    @Override
    public int compare(Bytes cacheKey, Windowed<Bytes> storeKey) {
        Bytes storeKeyBytes = SessionKeySerde.bytesToBinary(storeKey);
        return cacheKey.compareTo(storeKeyBytes);
    }
}

