/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlyWindowStore<K, V>
implements ReadOnlyWindowStore<K, V> {
    private final QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType;
    private final String storeName;
    private final StateStoreProvider provider;

    public CompositeReadOnlyWindowStore(StateStoreProvider provider, QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType, String storeName) {
        this.provider = provider;
        this.windowStoreType = windowStoreType;
        this.storeName = storeName;
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        List<ReadOnlyWindowStore<K, V>> stores = this.provider.stores(this.storeName, this.windowStoreType);
        for (ReadOnlyWindowStore<K, V> windowStore : stores) {
            try {
                WindowStoreIterator<V> result = windowStore.fetch(key, timeFrom, timeTo);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return new WindowStoreIterator<V>(){

            @Override
            public void close() {
            }

            @Override
            public Long peekNextKey() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public KeyValue<Long, V> next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };
    }
}

