/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.test.MockProcessorSupplier;

public class MockProcessorNode<K, V>
extends ProcessorNode<K, V> {
    public static final String NAME = "MOCK-PROCESS-";
    public static final AtomicInteger INDEX = new AtomicInteger(1);
    public int numReceived = 0;
    public final MockProcessorSupplier<K, V> supplier;
    public boolean initialized;

    public MockProcessorNode(long scheduleInterval) {
        this(new MockProcessorSupplier(scheduleInterval));
    }

    private MockProcessorNode(MockProcessorSupplier<K, V> supplier) {
        super(NAME + INDEX.getAndIncrement(), supplier.get(), Collections.emptySet());
        this.supplier = supplier;
    }

    public void init(ProcessorContext context) {
        super.init(context);
        this.initialized = true;
    }

    public void process(K key, V value) {
        ++this.numReceived;
        this.processor().process(key, value);
    }
}

