/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.internals.MeteredSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.SegmentedBytesStoreStub;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MeteredSegmentedBytesStoreTest {
    private final SegmentedBytesStoreStub bytesStore = new SegmentedBytesStoreStub();
    private final MeteredSegmentedBytesStore store = new MeteredSegmentedBytesStore((SegmentedBytesStore)this.bytesStore, "scope", (Time)new MockTime());
    private final Set<String> latencyRecorded = new HashSet<String>();
    private final Set<String> throughputRecorded = new HashSet<String>();

    @Before
    public void setUp() throws Exception {
        final Metrics metrics = new Metrics();
        final StreamsMetrics streamsMetrics = new StreamsMetrics(){

            public Map<MetricName, ? extends Metric> metrics() {
                return Collections.unmodifiableMap(metrics.metrics());
            }

            public Sensor addLatencyAndThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordLevel, String ... tags) {
                return metrics.sensor(operationName);
            }

            public void recordLatency(Sensor sensor, long startNs, long endNs) {
                MeteredSegmentedBytesStoreTest.this.latencyRecorded.add(sensor.name());
            }

            public Sensor addThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordLevel, String ... tags) {
                return metrics.sensor(operationName);
            }

            public void recordThroughput(Sensor sensor, long value) {
                MeteredSegmentedBytesStoreTest.this.throughputRecorded.add(sensor.name());
            }

            public void removeSensor(Sensor sensor) {
                metrics.removeSensor(sensor.name());
            }

            public Sensor addSensor(String name, Sensor.RecordingLevel recordLevel) {
                return metrics.sensor(name);
            }

            public Sensor addSensor(String name, Sensor.RecordingLevel recordLevel, Sensor ... parents) {
                return metrics.sensor(name);
            }
        };
        MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache("testCache", 0L, streamsMetrics)){

            @Override
            public StreamsMetrics metrics() {
                return streamsMetrics;
            }
        };
        this.store.init((ProcessorContext)context, (StateStore)this.store);
    }

    @Test
    public void shouldRecordRestoreLatencyOnInit() throws Exception {
        Assert.assertTrue((boolean)this.latencyRecorded.contains("restore"));
        Assert.assertTrue((boolean)this.bytesStore.initialized);
    }

    @Test
    public void shouldRecordPutLatency() throws Exception {
        this.store.put(Bytes.wrap((byte[])new byte[0]), new byte[0]);
        Assert.assertTrue((boolean)this.latencyRecorded.contains("put"));
        Assert.assertTrue((boolean)this.bytesStore.putCalled);
    }

    @Test
    public void shouldRecordFetchLatency() throws Exception {
        this.store.fetch(Bytes.wrap((byte[])new byte[0]), 1L, 1L).close();
        Assert.assertTrue((boolean)this.latencyRecorded.contains("fetch"));
        Assert.assertTrue((boolean)this.bytesStore.fetchCalled);
    }

    @Test
    public void shouldRecordRemoveLatency() throws Exception {
        this.store.remove(null);
        Assert.assertTrue((boolean)this.latencyRecorded.contains("remove"));
        Assert.assertTrue((boolean)this.bytesStore.removeCalled);
    }

    @Test
    public void shouldRecordFlushLatency() throws Exception {
        this.store.flush();
        Assert.assertTrue((boolean)this.latencyRecorded.contains("flush"));
        Assert.assertTrue((boolean)this.bytesStore.flushed);
    }

    @Test
    public void shouldRecordGetLatency() throws Exception {
        this.store.get(null);
        Assert.assertTrue((boolean)this.latencyRecorded.contains("get"));
        Assert.assertTrue((boolean)this.bytesStore.getCalled);
    }

    @Test
    public void shouldCloseUnderlyingStore() throws Exception {
        this.store.close();
        Assert.assertTrue((boolean)this.bytesStore.closed);
    }
}

