/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorNodeTest {
    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringInit() throws Exception {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        node.init(null);
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringClose() throws Exception {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        node.close();
    }

    @Test
    public void testMetrics() {
        StateSerdes anyStateSerde = StateSerdes.withBuiltinTypes((String)"anyName", Bytes.class, Bytes.class);
        MockProcessorContext context = new MockProcessorContext(anyStateSerde, (RecordCollector)new RecordCollectorImpl(null, null));
        ProcessorNode node = new ProcessorNode("name", (Processor)new NoOpProcessor(), Collections.emptySet());
        node.init((ProcessorContext)context);
        Metrics metrics = context.baseMetrics();
        String name = "task." + context.taskId() + "." + node.name();
        String[] entities = new String[]{"all", name};
        String[] latencyOperations = new String[]{"process", "punctuate", "create", "destroy"};
        String throughputOperation = "forward";
        String groupName = "stream-processor-node-metrics";
        Map<String, String> tags = Collections.singletonMap("processor-node-id", node.name());
        for (String operation : latencyOperations) {
            Assert.assertNotNull((Object)metrics.getSensor(operation));
            Assert.assertNotNull((Object)metrics.getSensor(name + "-" + operation));
        }
        Assert.assertNotNull((Object)metrics.getSensor(throughputOperation));
        for (String entity : entities) {
            for (String operation : latencyOperations) {
                Assert.assertNotNull(metrics.metrics().get(metrics.metricName(entity + "-" + operation + "-latency-avg", groupName, "The average latency in milliseconds of " + entity + " " + operation + " operation.", tags)));
                Assert.assertNotNull(metrics.metrics().get(metrics.metricName(entity + "-" + operation + "-latency-max", groupName, "The max latency in milliseconds of " + entity + " " + operation + " operation.", tags)));
                Assert.assertNotNull(metrics.metrics().get(metrics.metricName(entity + "-" + operation + "-rate", groupName, "The average number of occurrence of " + entity + " " + operation + " operation per second.", tags)));
            }
            Assert.assertNotNull(metrics.metrics().get(metrics.metricName(entity + "-" + throughputOperation + "-rate", groupName, "The average number of occurrence of " + entity + " " + throughputOperation + " operation per second.", tags)));
        }
    }

    private static class NoOpProcessor
    implements Processor {
        private NoOpProcessor() {
        }

        public void init(ProcessorContext context) {
        }

        public void process(Object key, Object value) {
        }

        public void punctuate(long timestamp) {
        }

        public void close() {
        }
    }

    private static class ExceptionalProcessor
    implements Processor {
        private ExceptionalProcessor() {
        }

        public void init(ProcessorContext context) {
            throw new RuntimeException();
        }

        public void process(Object key, Object value) {
            throw new RuntimeException();
        }

        public void punctuate(long timestamp) {
            throw new RuntimeException();
        }

        public void close() {
            throw new RuntimeException();
        }
    }
}

