/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.MockTimestampExtractor;
import org.junit.Assert;
import org.junit.Test;

public class PartitionGroupTest {
    private final Serializer<Integer> intSerializer = new IntegerSerializer();
    private final Deserializer<Integer> intDeserializer = new IntegerDeserializer();
    private final TimestampExtractor timestampExtractor = new MockTimestampExtractor();
    private final String[] topics = new String[]{"topic"};
    private final TopicPartition partition1 = new TopicPartition(this.topics[0], 1);
    private final TopicPartition partition2 = new TopicPartition(this.topics[0], 2);
    private final RecordQueue queue1 = new RecordQueue(this.partition1, new MockSourceNode<Integer, Integer>(this.topics, this.intDeserializer, this.intDeserializer), this.timestampExtractor);
    private final RecordQueue queue2 = new RecordQueue(this.partition2, new MockSourceNode<Integer, Integer>(this.topics, this.intDeserializer, this.intDeserializer), this.timestampExtractor);
    private final byte[] recordValue = this.intSerializer.serialize(null, (Object)10);
    private final byte[] recordKey = this.intSerializer.serialize(null, (Object)1);
    private final PartitionGroup group = new PartitionGroup((Map)new HashMap<TopicPartition, RecordQueue>(){
        {
            this.put(PartitionGroupTest.this.partition1, PartitionGroupTest.this.queue1);
            this.put(PartitionGroupTest.this.partition2, PartitionGroupTest.this.queue2);
        }
    }, this.timestampExtractor);

    @Test
    public void testTimeTracking() {
        Assert.assertEquals((long)0L, (long)this.group.numBuffered());
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 3L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        this.group.addRawRecords(this.partition1, list1);
        List<ConsumerRecord> list2 = Arrays.asList(new ConsumerRecord("topic", 2, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 4L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 6L, (Object)this.recordKey, (Object)this.recordValue));
        this.group.addRawRecords(this.partition2, list2);
        Assert.assertEquals((long)6L, (long)this.group.numBuffered());
        Assert.assertEquals((long)3L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)3L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)1L, (long)this.group.timestamp());
        PartitionGroup.RecordInfo info = new PartitionGroup.RecordInfo();
        StampedRecord record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        Assert.assertEquals((long)1L, (long)record.timestamp);
        Assert.assertEquals((long)5L, (long)this.group.numBuffered());
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)3L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)2L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition2, (Object)info.partition());
        Assert.assertEquals((long)2L, (long)record.timestamp);
        Assert.assertEquals((long)4L, (long)this.group.numBuffered());
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)3L, (long)this.group.timestamp());
        List<ConsumerRecord> list3 = Arrays.asList(new ConsumerRecord("topic", 1, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 4L, (Object)this.recordKey, (Object)this.recordValue));
        this.group.addRawRecords(this.partition1, list3);
        Assert.assertEquals((long)6L, (long)this.group.numBuffered());
        Assert.assertEquals((long)4L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)3L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        Assert.assertEquals((long)3L, (long)record.timestamp);
        Assert.assertEquals((long)5L, (long)this.group.numBuffered());
        Assert.assertEquals((long)3L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)3L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        Assert.assertEquals((long)5L, (long)record.timestamp);
        Assert.assertEquals((long)4L, (long)this.group.numBuffered());
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)3L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        Assert.assertEquals((long)2L, (long)record.timestamp);
        Assert.assertEquals((long)3L, (long)this.group.numBuffered());
        Assert.assertEquals((long)1L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)2L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)4L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition2, (Object)info.partition());
        Assert.assertEquals((long)4L, (long)record.timestamp);
        Assert.assertEquals((long)2L, (long)this.group.numBuffered());
        Assert.assertEquals((long)1L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)1L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)4L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        Assert.assertEquals((long)4L, (long)record.timestamp);
        Assert.assertEquals((long)1L, (long)this.group.numBuffered());
        Assert.assertEquals((long)0L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)1L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)4L, (long)this.group.timestamp());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition2, (Object)info.partition());
        Assert.assertEquals((long)6L, (long)record.timestamp);
        Assert.assertEquals((long)0L, (long)this.group.numBuffered());
        Assert.assertEquals((long)0L, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)0L, (long)this.group.numBuffered(this.partition2));
        Assert.assertEquals((long)4L, (long)this.group.timestamp());
    }
}

