/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.internals.KeyValuePrinter;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KeyValuePrinterProcessorTest {
    private final String topicName = "topic";
    private final Serde<String> stringSerde = Serdes.String();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final KStreamBuilder builder = new KStreamBuilder();
    private final PrintStream printStream = new PrintStream(this.baos);
    private KStreamTestDriver driver = null;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testPrintKeyValueDefaultSerde() throws Exception {
        KeyValuePrinter keyValuePrinter = new KeyValuePrinter(this.printStream, null);
        String[] suppliedKeys = new String[]{"foo", "bar", null};
        String[] suppliedValues = new String[]{"value1", "value2", "value3"};
        String[] expectedValues = new String[]{"[null]: foo , value1", "[null]: bar , value2", "[null]: null , value3"};
        KStream stream = this.builder.stream(this.stringSerde, this.stringSerde, new String[]{"topic"});
        stream.process((ProcessorSupplier)keyValuePrinter, new String[0]);
        this.driver = new KStreamTestDriver(this.builder);
        for (int i = 0; i < suppliedKeys.length; ++i) {
            this.driver.process("topic", suppliedKeys[i], suppliedValues[i]);
        }
        String[] capturedValues = new String(this.baos.toByteArray(), Charset.forName("UTF-8")).split("\n");
        for (int i = 0; i < capturedValues.length; ++i) {
            Assert.assertEquals((Object)capturedValues[i], (Object)expectedValues[i]);
        }
    }

    @Test
    public void testPrintKeyValuesWithName() throws Exception {
        KeyValuePrinter keyValuePrinter = new KeyValuePrinter(this.printStream, "test-stream");
        String[] suppliedKeys = new String[]{"foo", "bar", null};
        String[] suppliedValues = new String[]{"value1", "value2", "value3"};
        String[] expectedValues = new String[]{"[test-stream]: foo , value1", "[test-stream]: bar , value2", "[test-stream]: null , value3"};
        KStream stream = this.builder.stream(this.stringSerde, this.stringSerde, new String[]{"topic"});
        stream.process((ProcessorSupplier)keyValuePrinter, new String[0]);
        this.driver = new KStreamTestDriver(this.builder);
        for (int i = 0; i < suppliedKeys.length; ++i) {
            this.driver.process("topic", suppliedKeys[i], suppliedValues[i]);
        }
        String[] capturedValues = new String(this.baos.toByteArray(), Charset.forName("UTF-8")).split("\n");
        for (int i = 0; i < capturedValues.length; ++i) {
            Assert.assertEquals((Object)capturedValues[i], (Object)expectedValues[i]);
        }
    }

    @Test
    public void testPrintKeyValueWithProvidedSerde() throws Exception {
        Serde mockObjectSerde = Serdes.serdeFrom((Serializer)new MockSerializer(), (Deserializer)new MockDeserializer());
        KeyValuePrinter keyValuePrinter = new KeyValuePrinter(this.printStream, this.stringSerde, mockObjectSerde, null);
        KStream stream = this.builder.stream(this.stringSerde, mockObjectSerde, new String[]{"topic"});
        stream.process((ProcessorSupplier)keyValuePrinter, new String[0]);
        this.driver = new KStreamTestDriver(this.builder);
        Object suppliedKey = null;
        byte[] suppliedValue = "{\"name\":\"print\", \"label\":\"test\"}".getBytes(Charset.forName("UTF-8"));
        this.driver.process("topic", suppliedKey, suppliedValue);
        String expectedPrintedValue = "[null]: null , name:print label:test";
        String capturedValue = new String(this.baos.toByteArray(), Charset.forName("UTF-8")).trim();
        Assert.assertEquals((Object)capturedValue, (Object)expectedPrintedValue);
    }

    private static class MockSerializer
    implements Serializer<MockObject> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        private MockSerializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] serialize(String topic, MockObject data) {
            try {
                return this.objectMapper.writeValueAsBytes((Object)data);
            }
            catch (Exception e) {
                throw new SerializationException("Error serializing JSON message", (Throwable)e);
            }
        }

        public void close() {
        }
    }

    private static class MockDeserializer
    implements Deserializer<MockObject> {
        private ObjectMapper objectMapper = new ObjectMapper();

        private MockDeserializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public MockObject deserialize(String topic, byte[] data) {
            MockObject mockObject;
            try {
                mockObject = (MockObject)this.objectMapper.readValue(data, MockObject.class);
            }
            catch (Exception e) {
                throw new SerializationException((Throwable)e);
            }
            return mockObject;
        }

        public void close() {
        }
    }

    private static class MockObject {
        public String name;
        public String label;

        public MockObject() {
        }

        MockObject(String name, String label) {
            this.name = name;
            this.label = label;
        }

        public String toString() {
            return "name:" + this.name + " label:" + this.label;
        }
    }
}

