/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFlatMapValuesTest {
    private String topicName = "topic";
    private KStreamTestDriver driver = null;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testFlatMapValues() {
        KStreamBuilder builder = new KStreamBuilder();
        ValueMapper<Number, Iterable<String>> mapper = new ValueMapper<Number, Iterable<String>>(){

            public Iterable<String> apply(Number value) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("v" + value);
                result.add("V" + value);
                return result;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(Serdes.Integer(), Serdes.Integer(), new String[]{this.topicName});
        stream.flatMapValues((ValueMapper)mapper).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey);
        }
        Assert.assertEquals((long)8L, (long)processor.processed.size());
        String[] expected = new String[]{"0:v0", "0:V0", "1:v1", "1:V1", "2:v2", "2:V2", "3:v3", "3:V3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

