/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;

class SegmentIterator
implements KeyValueIterator<Bytes, byte[]> {
    private final Iterator<Segment> segments;
    private final HasNextCondition hasNextCondition;
    private final Bytes from;
    private final Bytes to;
    private KeyValueIterator<Bytes, byte[]> currentIterator;
    private KeyValueStore<Bytes, byte[]> currentSegment;

    SegmentIterator(Iterator<Segment> segments, HasNextCondition hasNextCondition, Bytes from, Bytes to) {
        this.segments = segments;
        this.hasNextCondition = hasNextCondition;
        this.from = from;
        this.to = to;
    }

    @Override
    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator = null;
        }
    }

    @Override
    public Bytes peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.peekNextKey();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        while (!(this.currentIterator != null && (hasNext = this.hasNextCondition.hasNext(this.currentIterator)) && this.currentSegment.isOpen() || !this.segments.hasNext())) {
            this.close();
            this.currentSegment = this.segments.next();
            try {
                this.currentIterator = this.currentSegment.range(this.from, this.to);
            }
            catch (InvalidStateStoreException invalidStateStoreException) {}
        }
        return this.currentIterator != null && hasNext;
    }

    @Override
    public KeyValue<Bytes, byte[]> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (KeyValue)this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

