/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

class MergedSortedCacheKeyValueStoreIterator<K, V>
extends AbstractMergedSortedCacheStoreIterator<K, Bytes, V> {
    MergedSortedCacheKeyValueStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Bytes, byte[]> storeIterator, StateSerdes<K, V> serdes) {
        super(cacheIterator, storeIterator, serdes);
    }

    @Override
    public KeyValue<K, V> deserializeStorePair(KeyValue<Bytes, byte[]> pair) {
        return KeyValue.pair(this.serdes.keyFrom(((Bytes)pair.key).get()), this.serdes.valueFrom((byte[])pair.value));
    }

    @Override
    K deserializeCacheKey(Bytes cacheKey) {
        return this.serdes.keyFrom(cacheKey.get());
    }

    @Override
    public K deserializeStoreKey(Bytes key) {
        return this.serdes.keyFrom(key.get());
    }

    @Override
    public int compare(Bytes cacheKey, Bytes storeKey) {
        return cacheKey.compareTo(storeKey);
    }
}

