/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;

public class WindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    private static final int TIMESTAMP_SIZE = 8;
    private Deserializer<T> inner;

    public WindowedDeserializer() {
    }

    public WindowedDeserializer(Deserializer<T> inner) {
        this.inner = inner;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "key.deserializer.inner.class" : "value.deserializer.inner.class";
            Object innerDeserializerClass = configs.get(propertyName);
            propertyName = innerDeserializerClass == null ? "deserializer.inner.class" : propertyName;
            String value = null;
            try {
                value = (String)configs.get(propertyName);
                this.inner = (Deserializer)Deserializer.class.cast(Utils.newInstance((String)value, Deserializer.class));
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, (Object)value, "Class " + value + " could not be found.");
            }
        }
    }

    public Windowed<T> deserialize(String topic, byte[] data) {
        byte[] bytes = new byte[data.length - 8];
        System.arraycopy(data, 0, bytes, 0, bytes.length);
        long start = ByteBuffer.wrap(data).getLong(data.length - 8);
        return new Windowed<Object>(this.inner.deserialize(topic, bytes), new UnlimitedWindow(start));
    }

    public void close() {
        this.inner.close();
    }

    public Deserializer<T> innerDeserializer() {
        return this.inner;
    }
}

