/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.tests.ShutdownDeadlockTest;
import org.apache.kafka.streams.tests.SmokeTestClient;
import org.apache.kafka.streams.tests.SmokeTestDriver;

public class StreamsSmokeTest {
    public static void main(String[] args) throws Exception {
        String kafka = args[0];
        String stateDir = args.length > 1 ? args[1] : null;
        String command = args.length > 2 ? args[2] : null;
        System.out.println("StreamsTest instance started");
        System.out.println("command=" + command);
        System.out.println("kafka=" + kafka);
        System.out.println("stateDir=" + stateDir);
        switch (command) {
            case "standalone": {
                SmokeTestDriver.main(args);
                break;
            }
            case "run": {
                int numKeys = 10;
                int maxRecordsPerKey = 500;
                Map<String, Set<Integer>> allData = SmokeTestDriver.generate(kafka, 10, 500);
                SmokeTestDriver.verify(kafka, allData, 500);
                break;
            }
            case "process": {
                final SmokeTestClient client = new SmokeTestClient(new File(stateDir), kafka);
                client.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        client.close();
                    }
                });
                break;
            }
            case "close-deadlock-test": {
                ShutdownDeadlockTest test = new ShutdownDeadlockTest(kafka);
                test.start();
                break;
            }
            default: {
                System.out.println("unknown command: " + command);
            }
        }
    }
}

