/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.kstream.internals.WindowedDeserializer;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.kstream.internals.WindowedStreamPartitioner;
import org.junit.Assert;
import org.junit.Test;

public class WindowedStreamPartitionerTest {
    private String topicName = "topic";
    private IntegerSerializer intSerializer = new IntegerSerializer();
    private StringSerializer stringSerializer = new StringSerializer();
    private List<PartitionInfo> infos = Arrays.asList(new PartitionInfo(this.topicName, 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 3, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 4, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 5, Node.noNode(), new Node[0], new Node[0]));
    private Cluster cluster = new Cluster("cluster", Collections.singletonList(Node.noNode()), this.infos, Collections.emptySet(), Collections.emptySet());

    @Test
    public void testCopartitioning() {
        Random rand = new Random();
        DefaultPartitioner defaultPartitioner = new DefaultPartitioner();
        WindowedSerializer windowedSerializer = new WindowedSerializer((Serializer)this.intSerializer);
        WindowedStreamPartitioner streamPartitioner = new WindowedStreamPartitioner(windowedSerializer);
        for (int k = 0; k < 10; ++k) {
            Integer key = rand.nextInt();
            byte[] keyBytes = this.intSerializer.serialize(this.topicName, key);
            String value = key.toString();
            byte[] valueBytes = this.stringSerializer.serialize(this.topicName, value);
            Integer expected = defaultPartitioner.partition("topic", (Object)key, keyBytes, (Object)value, valueBytes, this.cluster);
            for (int w = 1; w < 10; ++w) {
                TimeWindow window = new TimeWindow((long)(10 * w), (long)(20 * w));
                Windowed windowedKey = new Windowed((Object)key, (Window)window);
                Integer actual = streamPartitioner.partition(windowedKey, (Object)value, this.infos.size());
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testWindowedSerializerNoArgConstructors() {
        HashMap<String, String> props = new HashMap<String, String>();
        WindowedSerializer windowedSerializer = new WindowedSerializer();
        props.put("bootstrap.servers", "host:1");
        props.put("application.id", "appId");
        props.put("key.serializer.inner.class", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("serializer.inner.class", "org.apache.kafka.common.serialization.StringSerializer");
        windowedSerializer.configure(props, true);
        Serializer inner = windowedSerializer.innerSerializer();
        Assert.assertNotNull((String)"Inner serializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner serializer type should be StringSerializer", (boolean)(inner instanceof StringSerializer));
        props.put("serializer.inner.class", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.remove("key.serializer.inner.class");
        props.remove("value.serializer.inner.class");
        WindowedSerializer windowedSerializer1 = new WindowedSerializer();
        windowedSerializer1.configure(props, false);
        Serializer inner1 = windowedSerializer1.innerSerializer();
        Assert.assertNotNull((String)"Inner serializer should be not null", (Object)inner1);
        Assert.assertTrue((String)"Inner serializer type should be ByteArraySerializer", (boolean)(inner1 instanceof ByteArraySerializer));
    }

    @Test
    public void testWindowedDeserializerNoArgConstructors() {
        HashMap<String, String> props = new HashMap<String, String>();
        WindowedDeserializer windowedDeserializer = new WindowedDeserializer();
        props.put("bootstrap.servers", "host:1");
        props.put("application.id", "appId");
        props.put("key.deserializer.inner.class", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("deserializer.inner.class", "org.apache.kafka.common.serialization.StringDeserializer");
        windowedDeserializer.configure(props, true);
        Deserializer inner = windowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be StringDeserializer", (boolean)(inner instanceof StringDeserializer));
        props.put("deserializer.inner.class", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.remove("key.deserializer.inner.class");
        props.remove("value.deserializer.inner.class");
        WindowedDeserializer windowedDeserializer1 = new WindowedDeserializer();
        windowedDeserializer1.configure(props, false);
        Deserializer inner1 = windowedDeserializer1.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner1);
        Assert.assertTrue((String)"Inner deserializer type should be ByteArrayDeserializer", (boolean)(inner1 instanceof ByteArrayDeserializer));
    }
}

