/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsConfigTest {
    private Properties props = new Properties();
    private StreamsConfig streamsConfig;

    @Before
    public void setUp() {
        this.props.put("application.id", "streams-config-test");
        this.props.put("bootstrap.servers", "localhost:9092");
        this.props.put("key.serde", Serdes.String().getClass().getName());
        this.props.put("value.serde", Serdes.String().getClass().getName());
        this.props.put("DUMMY", "dummy");
        this.props.put("key.deserializer.encoding", "UTF8");
        this.props.put("value.deserializer.encoding", "UTF-16");
        this.streamsConfig = new StreamsConfig((Map)this.props);
    }

    @Test
    public void testGetProducerConfigs() throws Exception {
        Map returnedProps = this.streamsConfig.getProducerConfigs("client");
        Assert.assertEquals(returnedProps.get("client.id"), (Object)"client-producer");
        Assert.assertEquals(returnedProps.get("linger.ms"), (Object)"100");
        Assert.assertNull(returnedProps.get("DUMMY"));
    }

    @Test
    public void testGetConsumerConfigs() throws Exception {
        Map returnedProps = this.streamsConfig.getConsumerConfigs(null, "example-application", "client");
        Assert.assertEquals(returnedProps.get("client.id"), (Object)"client-consumer");
        Assert.assertEquals(returnedProps.get("group.id"), (Object)"example-application");
        Assert.assertEquals(returnedProps.get("max.poll.records"), (Object)"1000");
        Assert.assertNull(returnedProps.get("DUMMY"));
    }

    @Test
    public void testGetRestoreConsumerConfigs() throws Exception {
        Map returnedProps = this.streamsConfig.getRestoreConsumerConfigs("client");
        Assert.assertEquals(returnedProps.get("client.id"), (Object)"client-restore-consumer");
        Assert.assertNull(returnedProps.get("group.id"));
        Assert.assertNull(returnedProps.get("DUMMY"));
    }

    @Test
    public void defaultSerdeShouldBeConfigured() {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", "UTF8");
        serializerConfigs.put("value.serializer.encoding", "UTF-16");
        Serializer serializer = Serdes.String().serializer();
        String str = "my string for testing";
        String topic = "my topic";
        serializer.configure(serializerConfigs, true);
        Assert.assertEquals((String)"Should get the original string after serialization and deserialization with the configured encoding", (Object)str, (Object)this.streamsConfig.keySerde().deserializer().deserialize(topic, serializer.serialize(topic, (Object)str)));
        serializer.configure(serializerConfigs, false);
        Assert.assertEquals((String)"Should get the original string after serialization and deserialization with the configured encoding", (Object)str, (Object)this.streamsConfig.valueSerde().deserializer().deserialize(topic, serializer.serialize(topic, (Object)str)));
    }

    @Test
    public void shouldSupportMultipleBootstrapServers() {
        List<String> expectedBootstrapServers = Arrays.asList("broker1:9092", "broker2:9092");
        String bootstrapServersString = Utils.mkString(expectedBootstrapServers, (String)",").toString();
        Properties props = new Properties();
        props.put("application.id", "irrelevant");
        props.put("bootstrap.servers", bootstrapServersString);
        StreamsConfig config = new StreamsConfig((Map)props);
        List actualBootstrapServers = config.getList("bootstrap.servers");
        Assert.assertEquals(expectedBootstrapServers, (Object)actualBootstrapServers);
    }

    @Test
    public void shouldSupportPrefixedConsumerConfigs() throws Exception {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedRestoreConsumerConfigs() throws Exception {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfConsumerConfig() throws Exception {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfRestoreConsumerConfig() throws Exception {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfProducerConfig() throws Exception {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put(StreamsConfig.producerPrefix((String)"interceptor.statsd.host"), "host");
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"host", producerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedProducerConfigs() throws Exception {
        this.props.put(StreamsConfig.producerPrefix((String)"buffer.memory"), (Object)10);
        this.props.put(StreamsConfig.producerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getProducerConfigs("client");
        Assert.assertEquals((Object)10, configs.get("buffer.memory"));
        Assert.assertEquals((Object)1, configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedConsumerConfigs() throws Exception {
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedRestoreConsumerConfigs() throws Exception {
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("groupId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportNonPrefixedProducerConfigs() throws Exception {
        this.props.put("buffer.memory", (Object)10);
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getProducerConfigs("client");
        Assert.assertEquals((Object)10, configs.get("buffer.memory"));
        Assert.assertEquals((Object)1, configs.get("metrics.num.samples"));
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfKeySerdeConfigFails() throws Exception {
        this.props.put("key.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        streamsConfig.keySerde();
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfValueSerdeConfigFails() throws Exception {
        this.props.put("value.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        streamsConfig.valueSerde();
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConfigs() throws Exception {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "latest");
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"latest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)"10", consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldOverrideStreamsDefaultProducerConfigs() throws Exception {
        this.props.put(StreamsConfig.producerPrefix((String)"linger.ms"), "10000");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        Assert.assertEquals((Object)"10000", producerConfigs.get("linger.ms"));
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConifgsOnRestoreConsumer() throws Exception {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "latest");
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assert.assertEquals((Object)"latest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)"10", consumerConfigs.get("max.poll.records"));
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfConsumerAutoCommitIsOverridden() throws Exception {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        streamsConfig.getConsumerConfigs(null, "a", "b");
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfRestoreConsumerAutoCommitIsOverridden() throws Exception {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        streamsConfig.getRestoreConsumerConfigs("client");
    }

    static class MisconfiguredSerde
    implements Serde {
        MisconfiguredSerde() {
        }

        public void configure(Map configs, boolean isKey) {
            throw new RuntimeException("boom");
        }

        public void close() {
        }

        public Serializer serializer() {
            return null;
        }

        public Deserializer deserializer() {
            return null;
        }
    }
}

