/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.KeyValue;
import org.junit.Assert;
import org.junit.Test;

public class KeyValueTest {
    @Test
    public void shouldHaveSaneEqualsAndHashCode() {
        KeyValue kv = KeyValue.pair((Object)"key1", (Object)1L);
        KeyValue copyOfKV = KeyValue.pair((Object)kv.key, (Object)kv.value);
        Assert.assertTrue((boolean)kv.equals((Object)kv));
        Assert.assertTrue((kv.hashCode() == kv.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)kv.equals((Object)copyOfKV));
        Assert.assertTrue((kv.hashCode() == copyOfKV.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((copyOfKV.hashCode() == kv.hashCode() ? 1 : 0) != 0);
        KeyValue copyOfCopyOfKV = KeyValue.pair((Object)copyOfKV.key, (Object)copyOfKV.value);
        Assert.assertTrue((boolean)copyOfKV.equals((Object)copyOfCopyOfKV));
        Assert.assertTrue((copyOfKV.hashCode() == copyOfCopyOfKV.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)kv.equals((Object)copyOfCopyOfKV));
        Assert.assertTrue((kv.hashCode() == copyOfCopyOfKV.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"must be false for null", (boolean)kv.equals(null));
        Assert.assertFalse((String)"must be false if key is non-null and other key is null", (boolean)kv.equals((Object)KeyValue.pair(null, (Object)kv.value)));
        Assert.assertFalse((String)"must be false if value is non-null and other value is null", (boolean)kv.equals((Object)KeyValue.pair((Object)kv.key, null)));
        KeyValue differentKeyType = KeyValue.pair((Object)1L, (Object)kv.value);
        Assert.assertFalse((String)"must be false for different key types", (boolean)kv.equals((Object)differentKeyType));
        KeyValue differentValueType = KeyValue.pair((Object)kv.key, (Object)"anyString");
        Assert.assertFalse((String)"must be false for different value types", (boolean)kv.equals((Object)differentValueType));
        KeyValue differentKeyValueTypes = KeyValue.pair((Object)1L, (Object)"anyString");
        Assert.assertFalse((String)"must be false for different key and value types", (boolean)kv.equals((Object)differentKeyValueTypes));
        Assert.assertFalse((String)"must be false for different types of objects", (boolean)kv.equals(new Object()));
        KeyValue differentKey = KeyValue.pair((Object)((String)kv.key + "suffix"), (Object)kv.value);
        Assert.assertFalse((String)"must be false if key is different", (boolean)kv.equals((Object)differentKey));
        Assert.assertFalse((String)"must be false if key is different", (boolean)differentKey.equals((Object)kv));
        KeyValue differentValue = KeyValue.pair((Object)kv.key, (Object)((Long)kv.value + 1L));
        Assert.assertFalse((String)"must be false if value is different", (boolean)kv.equals((Object)differentValue));
        Assert.assertFalse((String)"must be false if value is different", (boolean)differentValue.equals((Object)kv));
        KeyValue differentKeyAndValue = KeyValue.pair((Object)((String)kv.key + "suffix"), (Object)((Long)kv.value + 1L));
        Assert.assertFalse((String)"must be false if key and value are different", (boolean)kv.equals((Object)differentKeyAndValue));
        Assert.assertFalse((String)"must be false if key and value are different", (boolean)differentKeyAndValue.equals((Object)kv));
    }
}

