/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public final class StateSerdes<K, V> {
    private final String stateName;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public static <K, V> StateSerdes<K, V> withBuiltinTypes(String stateName, Class<K> keyClass, Class<V> valueClass) {
        return new StateSerdes<K, V>(stateName, Serdes.serdeFrom(keyClass), Serdes.serdeFrom(valueClass));
    }

    public StateSerdes(String stateName, Serde<K> keySerde, Serde<V> valueSerde) {
        this.stateName = stateName;
        if (keySerde == null) {
            throw new IllegalArgumentException("key serde cannot be null");
        }
        if (valueSerde == null) {
            throw new IllegalArgumentException("value serde cannot be null");
        }
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public Deserializer<K> keyDeserializer() {
        return this.keySerde.deserializer();
    }

    public Serializer<K> keySerializer() {
        return this.keySerde.serializer();
    }

    public Deserializer<V> valueDeserializer() {
        return this.valueSerde.deserializer();
    }

    public Serializer<V> valueSerializer() {
        return this.valueSerde.serializer();
    }

    public String stateName() {
        return this.stateName;
    }

    public K keyFrom(byte[] rawKey) {
        return (K)this.keySerde.deserializer().deserialize(this.stateName, rawKey);
    }

    public V valueFrom(byte[] rawValue) {
        return (V)this.valueSerde.deserializer().deserialize(this.stateName, rawValue);
    }

    public byte[] rawKey(K key) {
        return this.keySerde.serializer().serialize(this.stateName, key);
    }

    public byte[] rawValue(V value) {
        return this.valueSerde.serializer().serialize(this.stateName, value);
    }
}

