/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class ProcessorTopology {
    private final List<ProcessorNode> processorNodes;
    private final Map<String, SourceNode> sourceByTopics;
    private final Map<String, SinkNode> sinkByTopics;
    private final List<StateStore> stateStores;
    private final Map<String, String> sourceStoreToSourceTopic;
    private final Map<StateStore, ProcessorNode> storeToProcessorNodeMap;

    public ProcessorTopology(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourceByTopics, Map<String, SinkNode> sinkByTopics, List<StateStore> stateStores, Map<String, String> sourceStoreToSourceTopic, Map<StateStore, ProcessorNode> storeToProcessorNodeMap) {
        this.processorNodes = Collections.unmodifiableList(processorNodes);
        this.sourceByTopics = Collections.unmodifiableMap(sourceByTopics);
        this.sinkByTopics = Collections.unmodifiableMap(sinkByTopics);
        this.stateStores = Collections.unmodifiableList(stateStores);
        this.sourceStoreToSourceTopic = sourceStoreToSourceTopic;
        this.storeToProcessorNodeMap = Collections.unmodifiableMap(storeToProcessorNodeMap);
    }

    public Set<String> sourceTopics() {
        return this.sourceByTopics.keySet();
    }

    public SourceNode source(String topic) {
        return this.sourceByTopics.get(topic);
    }

    public Set<SourceNode> sources() {
        return new HashSet<SourceNode>(this.sourceByTopics.values());
    }

    public Set<String> sinkTopics() {
        return this.sinkByTopics.keySet();
    }

    public SinkNode sink(String topic) {
        return this.sinkByTopics.get(topic);
    }

    public Set<SinkNode> sinks() {
        return new HashSet<SinkNode>(this.sinkByTopics.values());
    }

    public List<ProcessorNode> processors() {
        return this.processorNodes;
    }

    public List<StateStore> stateStores() {
        return this.stateStores;
    }

    public Map<String, String> sourceStoreToSourceTopic() {
        return this.sourceStoreToSourceTopic;
    }

    public Map<StateStore, ProcessorNode> storeToProcessorNodeMap() {
        return this.storeToProcessorNodeMap;
    }

    private String childrenToString(List<ProcessorNode<?, ?>> children) {
        if (children == null || children.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("children [");
        for (ProcessorNode<?, ?> child : children) {
            sb.append(child.name() + ",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]\n");
        for (ProcessorNode<?, ?> child : children) {
            sb.append("\t\t\t\t" + child.toString());
            sb.append(this.childrenToString(child.children()));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProcessorTopology:\n");
        for (SourceNode source : this.sourceByTopics.values()) {
            sb.append("\t\t\t\t" + source.toString());
            sb.append(this.childrenToString(source.children()));
            sb.append("\n");
        }
        return sb.toString();
    }
}

