/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.Windowed;

public class WindowedSerializer<T>
implements Serializer<Windowed<T>> {
    private static final int TIMESTAMP_SIZE = 8;
    private Serializer<T> inner;

    public WindowedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, Windowed<T> data) {
        byte[] serializedKey = this.inner.serialize(topic, data.key());
        ByteBuffer buf = ByteBuffer.allocate(serializedKey.length + 8);
        buf.put(serializedKey);
        buf.putLong(data.window().start());
        return buf.array();
    }

    public void close() {
        this.inner.close();
    }

    public byte[] serializeBaseKey(String topic, Windowed<T> data) {
        return this.inner.serialize(topic, data.key());
    }
}

