/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KGroupedTableImpl;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamForeach;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamMapValues;
import org.apache.kafka.streams.kstream.internals.KTableFilter;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoinMerger;
import org.apache.kafka.streams.kstream.internals.KTableKTableLeftJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableOuterJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.kstream.internals.KTableMapValues;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableRepartitionMap;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KTableSourceValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KeyValuePrinter;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class KTableImpl<K, S, V>
extends AbstractStream<K>
implements KTable<K, V> {
    private static final String FILTER_NAME = "KTABLE-FILTER-";
    private static final String FOREACH_NAME = "KTABLE-FOREACH-";
    public static final String JOINTHIS_NAME = "KTABLE-JOINTHIS-";
    public static final String JOINOTHER_NAME = "KTABLE-JOINOTHER-";
    public static final String LEFTTHIS_NAME = "KTABLE-LEFTTHIS-";
    public static final String LEFTOTHER_NAME = "KTABLE-LEFTOTHER-";
    private static final String MAPVALUES_NAME = "KTABLE-MAPVALUES-";
    public static final String MERGE_NAME = "KTABLE-MERGE-";
    public static final String OUTERTHIS_NAME = "KTABLE-OUTERTHIS-";
    public static final String OUTEROTHER_NAME = "KTABLE-OUTEROTHER-";
    private static final String PRINTING_NAME = "KSTREAM-PRINTER-";
    private static final String SELECT_NAME = "KTABLE-SELECT-";
    public static final String SOURCE_NAME = "KTABLE-SOURCE-";
    private static final String TOSTREAM_NAME = "KTABLE-TOSTREAM-";
    public final ProcessorSupplier<?, ?> processorSupplier;
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;
    private final String storeName;
    private boolean sendOldValues = false;

    public KTableImpl(KStreamBuilder topology, String name, ProcessorSupplier<?, ?> processorSupplier, Set<String> sourceNodes, String storeName) {
        this(topology, name, processorSupplier, sourceNodes, null, null, storeName);
    }

    public KTableImpl(KStreamBuilder topology, String name, ProcessorSupplier<?, ?> processorSupplier, Set<String> sourceNodes, Serde<K> keySerde, Serde<V> valSerde, String storeName) {
        super(topology, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.storeName = storeName;
    }

    @Override
    public String getStoreName() {
        return this.storeName;
    }

    @Override
    public KTable<K, V> filter(Predicate<K, V> predicate) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        String name = this.topology.newName(FILTER_NAME);
        KTableFilter<K, V> processorSupplier = new KTableFilter<K, V>(this, predicate, false);
        this.topology.addProcessor(name, processorSupplier, this.name);
        return new KTableImpl<K, S, V>(this.topology, name, processorSupplier, this.sourceNodes, this.storeName);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<K, V> predicate) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        String name = this.topology.newName(FILTER_NAME);
        KTableFilter<K, V> processorSupplier = new KTableFilter<K, V>(this, predicate, true);
        this.topology.addProcessor(name, processorSupplier, this.name);
        return new KTableImpl<K, S, V>(this.topology, name, processorSupplier, this.sourceNodes, this.storeName);
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<V, V1> mapper) {
        Objects.requireNonNull(mapper);
        String name = this.topology.newName(MAPVALUES_NAME);
        KTableMapValues processorSupplier = new KTableMapValues(this, mapper);
        this.topology.addProcessor(name, processorSupplier, this.name);
        return new KTableImpl<K, S, V>(this.topology, name, processorSupplier, this.sourceNodes, this.storeName);
    }

    @Override
    public void print() {
        this.print(null, null, null);
    }

    @Override
    public void print(String streamName) {
        this.print(null, null, streamName);
    }

    @Override
    public void print(Serde<K> keySerde, Serde<V> valSerde) {
        this.print(keySerde, valSerde, null);
    }

    @Override
    public void print(Serde<K> keySerde, Serde<V> valSerde, String streamName) {
        String name = this.topology.newName(PRINTING_NAME);
        streamName = streamName == null ? this.name : streamName;
        this.topology.addProcessor(name, new KeyValuePrinter(keySerde, valSerde, streamName), this.name);
    }

    @Override
    public void writeAsText(String filePath) {
        this.writeAsText(filePath, null, null, null);
    }

    @Override
    public void writeAsText(String filePath, String streamName) {
        this.writeAsText(filePath, streamName, null, null);
    }

    @Override
    public void writeAsText(String filePath, Serde<K> keySerde, Serde<V> valSerde) {
        this.writeAsText(filePath, null, keySerde, valSerde);
    }

    @Override
    public void writeAsText(String filePath, String streamName, Serde<K> keySerde, Serde<V> valSerde) {
        String name = this.topology.newName(PRINTING_NAME);
        streamName = streamName == null ? this.name : streamName;
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(filePath));
            this.topology.addProcessor(name, new KeyValuePrinter(printStream, keySerde, valSerde, streamName), this.name);
        }
        catch (FileNotFoundException e) {
            String message = "Unable to write stream to file at [" + filePath + "] " + e.getMessage();
            throw new TopologyBuilderException(message);
        }
    }

    @Override
    public void foreach(final ForeachAction<K, V> action) {
        Objects.requireNonNull(action, "action can't be null");
        String name = this.topology.newName(FOREACH_NAME);
        KStreamForeach processorSupplier = new KStreamForeach(new ForeachAction<K, Change<V>>(){

            @Override
            public void apply(K key, Change<V> value) {
                action.apply(key, value.newValue);
            }
        });
        this.topology.addProcessor(name, processorSupplier, this.name);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<K, V> partitioner, String topic, String storeName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        this.to(keySerde, valSerde, partitioner, topic);
        return this.topology.table(keySerde, valSerde, topic, storeName);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic, String storeName) {
        return this.through(keySerde, valSerde, null, topic, storeName);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<K, V> partitioner, String topic, String storeName) {
        return this.through(null, null, partitioner, topic, storeName);
    }

    @Override
    public KTable<K, V> through(String topic, String storeName) {
        return this.through(null, null, null, topic, storeName);
    }

    @Override
    public void to(String topic) {
        this.to(null, null, null, topic);
    }

    @Override
    public void to(StreamPartitioner<K, V> partitioner, String topic) {
        this.to(null, null, partitioner, topic);
    }

    @Override
    public void to(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        this.toStream().to(keySerde, valSerde, null, topic);
    }

    @Override
    public void to(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<K, V> partitioner, String topic) {
        this.toStream().to(keySerde, valSerde, partitioner, topic);
    }

    @Override
    public KStream<K, V> toStream() {
        String name = this.topology.newName(TOSTREAM_NAME);
        this.topology.addProcessor(name, new KStreamMapValues(new ValueMapper<Change<V>, V>(){

            @Override
            public V apply(Change<V> change) {
                return change.newValue;
            }
        }), this.name);
        return new KStreamImpl(this.topology, name, this.sourceNodes, false);
    }

    @Override
    public <K1> KStream<K1, V> toStream(KeyValueMapper<K, V, K1> mapper) {
        return this.toStream().selectKey(mapper);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<V, V1, R> joiner) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        Set<String> allSourceNodes = this.ensureJoinableWith((AbstractStream)((Object)other));
        String joinThisName = this.topology.newName(JOINTHIS_NAME);
        String joinOtherName = this.topology.newName(JOINOTHER_NAME);
        String joinMergeName = this.topology.newName(MERGE_NAME);
        KTableKTableJoin joinThis = new KTableKTableJoin(this, (KTableImpl)other, joiner);
        KTableKTableJoin joinOther = new KTableKTableJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        KTableKTableJoinMerger<K, V> joinMerge = new KTableKTableJoinMerger<K, V>(new KTableImpl<K, S, V>(this.topology, joinThisName, joinThis, this.sourceNodes, this.storeName), new KTableImpl<K, S, V>(this.topology, joinOtherName, joinOther, ((KTableImpl)other).sourceNodes, other.getStoreName()));
        this.topology.addProcessor(joinThisName, joinThis, this.name);
        this.topology.addProcessor(joinOtherName, joinOther, ((KTableImpl)other).name);
        this.topology.addProcessor(joinMergeName, joinMerge, joinThisName, joinOtherName);
        this.topology.connectProcessorAndStateStores(joinThisName, ((KTableImpl)other).valueGetterSupplier().storeNames());
        this.topology.connectProcessorAndStateStores(joinOtherName, this.valueGetterSupplier().storeNames());
        return new KTableImpl<K, S, V>(this.topology, joinMergeName, joinMerge, allSourceNodes, null);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<V, V1, R> joiner) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        Set<String> allSourceNodes = this.ensureJoinableWith((AbstractStream)((Object)other));
        String joinThisName = this.topology.newName(OUTERTHIS_NAME);
        String joinOtherName = this.topology.newName(OUTEROTHER_NAME);
        String joinMergeName = this.topology.newName(MERGE_NAME);
        KTableKTableOuterJoin joinThis = new KTableKTableOuterJoin(this, (KTableImpl)other, joiner);
        KTableKTableOuterJoin joinOther = new KTableKTableOuterJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        KTableKTableJoinMerger<K, V> joinMerge = new KTableKTableJoinMerger<K, V>(new KTableImpl<K, S, V>(this.topology, joinThisName, joinThis, this.sourceNodes, this.storeName), new KTableImpl<K, S, V>(this.topology, joinOtherName, joinOther, ((KTableImpl)other).sourceNodes, other.getStoreName()));
        this.topology.addProcessor(joinThisName, joinThis, this.name);
        this.topology.addProcessor(joinOtherName, joinOther, ((KTableImpl)other).name);
        this.topology.addProcessor(joinMergeName, joinMerge, joinThisName, joinOtherName);
        this.topology.connectProcessorAndStateStores(joinThisName, ((KTableImpl)other).valueGetterSupplier().storeNames());
        this.topology.connectProcessorAndStateStores(joinOtherName, this.valueGetterSupplier().storeNames());
        return new KTableImpl<K, S, V>(this.topology, joinMergeName, joinMerge, allSourceNodes, null);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<V, V1, R> joiner) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        Set<String> allSourceNodes = this.ensureJoinableWith((AbstractStream)((Object)other));
        String joinThisName = this.topology.newName(LEFTTHIS_NAME);
        String joinOtherName = this.topology.newName(LEFTOTHER_NAME);
        String joinMergeName = this.topology.newName(MERGE_NAME);
        KTableKTableLeftJoin joinThis = new KTableKTableLeftJoin(this, (KTableImpl)other, joiner);
        KTableKTableRightJoin joinOther = new KTableKTableRightJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        KTableKTableJoinMerger<K, V> joinMerge = new KTableKTableJoinMerger<K, V>(new KTableImpl<K, S, V>(this.topology, joinThisName, joinThis, this.sourceNodes, this.storeName), new KTableImpl<K, S, V>(this.topology, joinOtherName, joinOther, ((KTableImpl)other).sourceNodes, other.getStoreName()));
        this.topology.addProcessor(joinThisName, joinThis, this.name);
        this.topology.addProcessor(joinOtherName, joinOther, ((KTableImpl)other).name);
        this.topology.addProcessor(joinMergeName, joinMerge, joinThisName, joinOtherName);
        this.topology.connectProcessorAndStateStores(joinThisName, ((KTableImpl)other).valueGetterSupplier().storeNames());
        this.topology.connectProcessorAndStateStores(joinOtherName, this.valueGetterSupplier().storeNames());
        return new KTableImpl<K, S, V>(this.topology, joinMergeName, joinMerge, allSourceNodes, null);
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<K, V, KeyValue<K1, V1>> selector, Serde<K1> keySerde, Serde<V1> valueSerde) {
        Objects.requireNonNull(selector, "selector can't be null");
        String selectName = this.topology.newName(SELECT_NAME);
        KTableRepartitionMap<K, V, K1, V1> selectSupplier = new KTableRepartitionMap<K, V, K1, V1>(this, selector);
        this.topology.addProcessor(selectName, selectSupplier, this.name);
        this.enableSendingOldValues();
        return new KGroupedTableImpl<K1, V1>(this.topology, selectName, this.name, keySerde, valueSerde);
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<K, V, KeyValue<K1, V1>> selector) {
        return this.groupBy(selector, null, null);
    }

    KTableValueGetterSupplier<K, V> valueGetterSupplier() {
        if (this.processorSupplier instanceof KTableSource) {
            KTableSource source = (KTableSource)this.processorSupplier;
            return new KTableSourceValueGetterSupplier(source.storeName);
        }
        if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
            return ((KStreamAggProcessorSupplier)this.processorSupplier).view();
        }
        return ((KTableProcessorSupplier)this.processorSupplier).view();
    }

    void enableSendingOldValues() {
        if (!this.sendOldValues) {
            if (this.processorSupplier instanceof KTableSource) {
                KTableSource source = (KTableSource)this.processorSupplier;
                source.enableSendingOldValues();
            } else if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
                ((KStreamAggProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            } else {
                ((KTableProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            }
            this.sendOldValues = true;
        }
    }

    boolean sendingOldValueEnabled() {
        return this.sendOldValues;
    }
}

