/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public class KStreamTransform<K, V, K1, V1>
implements ProcessorSupplier<K, V> {
    private final TransformerSupplier<K, V, KeyValue<K1, V1>> transformerSupplier;

    public KStreamTransform(TransformerSupplier<K, V, KeyValue<K1, V1>> transformerSupplier) {
        this.transformerSupplier = transformerSupplier;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamTransformProcessor<K, V, K1, V1>(this.transformerSupplier.get());
    }

    public static class KStreamTransformProcessor<K1, V1, K2, V2>
    extends AbstractProcessor<K1, V1> {
        private final Transformer<K1, V1, KeyValue<K2, V2>> transformer;

        public KStreamTransformProcessor(Transformer<K1, V1, KeyValue<K2, V2>> transformer) {
            this.transformer = transformer;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.transformer.init(context);
        }

        @Override
        public void process(K1 key, V1 value) {
            KeyValue<K2, V2> pair = this.transformer.transform(key, value);
            if (pair != null) {
                this.context().forward(pair.key, pair.value);
            }
        }

        @Override
        public void punctuate(long timestamp) {
            KeyValue<K2, V2> pair = this.transformer.punctuate(timestamp);
            if (pair != null) {
                this.context().forward(pair.key, pair.value);
            }
        }

        @Override
        public void close() {
            this.transformer.close();
        }
    }
}

