/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.session;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.ShareRequestMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.session.LastUsedKey;
import org.apache.kafka.server.share.session.ShareSession;
import org.apache.kafka.server.share.session.ShareSessionKey;

public class ShareSessionCache {
    private final int maxEntries;
    private final long evictionMs;
    private long numPartitions = 0L;
    private final Map<ShareSessionKey, ShareSession> sessions = new HashMap<ShareSessionKey, ShareSession>();
    private final TreeMap<LastUsedKey, ShareSession> lastUsed = new TreeMap();

    public ShareSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
    }

    public synchronized ShareSession get(ShareSessionKey key) {
        return this.sessions.getOrDefault(key, null);
    }

    public synchronized int size() {
        return this.sessions.size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions;
    }

    public synchronized ShareSession remove(ShareSessionKey key) {
        ShareSession session = this.get(key);
        if (session != null) {
            return this.remove(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ShareSession remove(ShareSession session) {
        ShareSession shareSession = session;
        synchronized (shareSession) {
            this.lastUsed.remove(session.lastUsedKey());
        }
        ShareSession removeResult = this.sessions.remove(session.key());
        if (removeResult != null) {
            this.numPartitions -= (long)session.cachedSize();
        }
        return removeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void touch(ShareSession session, long now) {
        ShareSession shareSession = session;
        synchronized (shareSession) {
            this.lastUsed.remove(session.lastUsedKey());
            session.lastUsedMs(now);
            this.lastUsed.put(session.lastUsedKey(), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                this.numPartitions -= (long)oldSize;
            }
            session.cachedSize(session.size());
            this.numPartitions += (long)session.cachedSize();
        }
    }

    public synchronized boolean tryEvict(long now) {
        Map.Entry<LastUsedKey, ShareSession> lastUsedEntry = this.lastUsed.firstEntry();
        if (lastUsedEntry == null) {
            return false;
        }
        if (now - lastUsedEntry.getKey().lastUsedMs() > this.evictionMs) {
            ShareSession session = lastUsedEntry.getValue();
            this.remove(session);
            return true;
        }
        return false;
    }

    public synchronized ShareSessionKey maybeCreateSession(String groupId, Uuid memberId, long now, ImplicitLinkedHashCollection<CachedSharePartition> partitionMap) {
        if (this.sessions.size() < this.maxEntries || this.tryEvict(now)) {
            ShareSession session = new ShareSession(new ShareSessionKey(groupId, memberId), partitionMap, now, now, ShareRequestMetadata.nextEpoch((int)0));
            this.sessions.put(session.key(), session);
            this.touch(session, now);
            return session.key();
        }
        return null;
    }
}

