/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.kafka.server.immutable.DelegationChecker;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.apache.kafka.server.immutable.pcollections.PCollectionsImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.pcollections.AbstractUnmodifiableSet;
import org.pcollections.HashTreePSet;
import org.pcollections.MapPSet;

public class PCollectionsImmutableSetTest {
    private static final MapPSet<Object> SINGLETON_SET = HashTreePSet.singleton((Object)new Object());

    @Test
    public void testEmptySet() {
        Assertions.assertEquals((Object)HashTreePSet.empty(), (Object)((PCollectionsImmutableSet)ImmutableSet.empty()).underlying());
    }

    @Test
    public void testSingletonSet() {
        Assertions.assertEquals((Object)HashTreePSet.singleton((Object)1), (Object)((PCollectionsImmutableSet)ImmutableSet.singleton((Object)1)).underlying());
    }

    @Test
    public void testUnderlying() {
        Assertions.assertSame(SINGLETON_SET, (Object)new PCollectionsImmutableSet(SINGLETON_SET).underlying());
    }

    @Test
    public void testDelegationOfAdded() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.plus(ArgumentMatchers.eq((Object)this)), SINGLETON_SET).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.added((Object)this), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfRemoved() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.minus(ArgumentMatchers.eq((Object)this)), SINGLETON_SET).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.removed((Object)this), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfSize(int mockFunctionReturnValue) {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(MapPSet::size, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::size, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfIsEmpty(boolean mockFunctionReturnValue) {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractCollection::isEmpty, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::isEmpty, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContains(boolean mockFunctionReturnValue) {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.contains(ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.contains((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfIterator() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(MapPSet::iterator, Mockito.mock(Iterator.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::iterator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfForEach() {
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.forEach((Consumer)ArgumentMatchers.eq((Object)mockConsumer))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.forEach(mockConsumer)).doVoidMethodDelegationCheck();
    }

    @Test
    public void testDelegationOfToArray() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractCollection::toArray, new Object[0]).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::toArray, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfToArrayIntoGivenDestination() {
        Object[] destinationArray = new Object[]{};
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.toArray((Object[])ArgumentMatchers.eq((Object)destinationArray)), new Object[0]).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.toArray(destinationArray), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionAdd() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.add(ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.add((Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemove() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.remove(ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.remove((Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContainsAll(boolean mockFunctionReturnValue) {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.containsAll((Collection)ArgumentMatchers.eq(Collections.emptyList())), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.containsAll(Collections.emptyList()), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionAddAll() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.addAll((Collection)ArgumentMatchers.eq(Collections.emptyList()))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.addAll(Collections.emptyList())).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRetainAll() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.retainAll((Collection)ArgumentMatchers.eq(Collections.emptyList()))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.retainAll(Collections.emptyList())).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemoveAll() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.removeAll((Collection)ArgumentMatchers.eq(Collections.emptyList()))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.removeAll(Collections.emptyList())).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemoveIf() {
        Predicate mockPredicate = (Predicate)Mockito.mock(Predicate.class);
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.removeIf((Predicate)ArgumentMatchers.eq((Object)mockPredicate))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.removeIf(mockPredicate)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionClear() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(AbstractUnmodifiableSet::clear).defineWrapperVoidMethodInvocation(PCollectionsImmutableSet::clear).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfSpliterator() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(Set::spliterator, Mockito.mock(Spliterator.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::spliterator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfStream() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(Collection::stream, Mockito.mock(Stream.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::stream, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfParallelStream() {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(Collection::parallelStream, Mockito.mock(Stream.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::parallelStream, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testEquals() {
        MapPSet mock = (MapPSet)Mockito.mock(MapPSet.class);
        Assertions.assertEquals((Object)new PCollectionsImmutableSet(mock), (Object)new PCollectionsImmutableSet(mock));
        MapPSet someOtherMock = (MapPSet)Mockito.mock(MapPSet.class);
        Assertions.assertNotEquals((Object)new PCollectionsImmutableSet(mock), (Object)new PCollectionsImmutableSet(someOtherMock));
    }

    @Test
    public void testHashCode() {
        MapPSet mock = (MapPSet)Mockito.mock(MapPSet.class);
        Assertions.assertEquals((int)mock.hashCode(), (int)new PCollectionsImmutableSet(mock).hashCode());
        MapPSet someOtherMock = (MapPSet)Mockito.mock(MapPSet.class);
        Assertions.assertNotEquals((int)mock.hashCode(), (int)new PCollectionsImmutableSet(someOtherMock).hashCode());
    }

    @ParameterizedTest
    @ValueSource(strings={"a", "b"})
    public void testDelegationOfToString(String mockFunctionReturnValue) {
        new PCollectionsHashSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractCollection::toString, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableSet::toString, text -> "PCollectionsImmutableSet{underlying=" + text + "}").doFunctionDelegationCheck();
    }

    private static final class PCollectionsHashSetWrapperDelegationChecker<R>
    extends DelegationChecker<MapPSet<Object>, PCollectionsImmutableSet<Object>, R> {
        public PCollectionsHashSetWrapperDelegationChecker() {
            super(Mockito.mock(MapPSet.class), PCollectionsImmutableSet::new);
        }

        @Override
        public MapPSet<Object> unwrap(PCollectionsImmutableSet<Object> wrapper) {
            return wrapper.underlying();
        }
    }
}

