/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.fault;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoggingFaultHandlerTest {
    @Test
    public void testHandleFault() {
        AtomicInteger counter = new AtomicInteger(0);
        LoggingFaultHandler handler = new LoggingFaultHandler("test", () -> counter.incrementAndGet());
        handler.handleFault("uh oh");
        Assertions.assertEquals((int)1, (int)counter.get());
        handler.handleFault("uh oh", (Throwable)new RuntimeException("yikes"));
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    public void testHandleExceptionInAction() {
        LoggingFaultHandler handler = new LoggingFaultHandler("test", () -> {
            throw new RuntimeException("action failed");
        });
        handler.handleFault("uh oh");
        handler.handleFault("uh oh", (Throwable)new RuntimeException("yikes"));
    }
}

