/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.rest.entities.ErrorMessage;
import org.apache.kafka.connect.runtime.rest.errors.ConnectExceptionMapper;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.apache.kafka.connect.runtime.rest.resources.RootResource;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServer {
    private static final Logger log = LoggerFactory.getLogger(RestServer.class);
    private static final long GRACEFUL_SHUTDOWN_TIMEOUT_MS = 60000L;
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private final WorkerConfig config;
    private Server jettyServer;

    public RestServer(WorkerConfig config) {
        this.config = config;
        String hostname = config.getString("rest.host.name");
        Integer port = config.getInt("rest.port");
        this.jettyServer = new Server();
        ServerConnector connector = new ServerConnector(this.jettyServer);
        if (hostname != null && !hostname.isEmpty()) {
            connector.setHost(hostname);
        }
        connector.setPort(port.intValue());
        this.jettyServer.setConnectors(new Connector[]{connector});
    }

    public void start(Herder herder) {
        log.info("Starting REST server");
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)new JacksonJsonProvider());
        resourceConfig.register(RootResource.class);
        resourceConfig.register((Object)new ConnectorsResource(herder));
        resourceConfig.register((Object)new ConnectorPluginsResource(herder));
        resourceConfig.register(ConnectExceptionMapper.class);
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder servletHolder = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(servletHolder, "/*");
        String allowedOrigins = this.config.getString("access.control.allow.origin");
        if (allowedOrigins != null && !allowedOrigins.trim().isEmpty()) {
            FilterHolder filterHolder = new FilterHolder((Filter)new CrossOriginFilter());
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.config.getString("access.control.allow.methods");
            if (allowedMethods != null && !allowedOrigins.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setLoggerName(RestServer.class.getCanonicalName());
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler(), requestLogHandler});
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        this.jettyServer.setHandler((Handler)statsHandler);
        this.jettyServer.setStopTimeout(60000L);
        this.jettyServer.setStopAtShutdown(true);
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to start REST server", (Throwable)e);
        }
        log.info("REST server listening at " + this.jettyServer.getURI() + ", advertising URL " + this.advertisedUrl());
    }

    public void stop() {
        log.info("Stopping REST server");
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to stop REST server", (Throwable)e);
        }
        finally {
            this.jettyServer.destroy();
        }
        log.info("REST server stopped");
    }

    public URI advertisedUrl() {
        Integer advertisedPort;
        UriBuilder builder = UriBuilder.fromUri((URI)this.jettyServer.getURI());
        String advertisedHostname = this.config.getString("rest.advertised.host.name");
        if (advertisedHostname != null && !advertisedHostname.isEmpty()) {
            builder.host(advertisedHostname);
        }
        if ((advertisedPort = this.config.getInt("rest.advertised.port")) != null) {
            builder.port(advertisedPort.intValue());
        } else {
            builder.port(this.config.getInt("rest.port").intValue());
        }
        return builder.build(new Object[0]);
    }

    public static <T> HttpResponse<T> httpRequest(String url, String method, Object requestBodyData, TypeReference<T> responseFormat) {
        HttpURLConnection connection = null;
        try {
            int responseCode;
            String serializedBody = requestBodyData == null ? null : JSON_SERDE.writeValueAsString(requestBodyData);
            log.debug("Sending {} with input {} to {}", new Object[]{method, serializedBody, url});
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod(method);
            connection.setRequestProperty("User-Agent", "kafka-connect");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoInput(true);
            connection.setUseCaches(false);
            if (requestBodyData != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(serializedBody.getBytes(StandardCharsets.UTF_8));
                os.flush();
                os.close();
            }
            if ((responseCode = connection.getResponseCode()) == 204) {
                HttpResponse<Object> httpResponse = new HttpResponse<Object>(responseCode, connection.getHeaderFields(), null);
                return httpResponse;
            }
            if (responseCode >= 400) {
                InputStream es = connection.getErrorStream();
                ErrorMessage errorMessage = (ErrorMessage)JSON_SERDE.readValue(es, ErrorMessage.class);
                es.close();
                throw new ConnectRestException(responseCode, errorMessage.errorCode(), errorMessage.message());
            }
            if (responseCode >= 200 && responseCode < 300) {
                InputStream is = connection.getInputStream();
                Object result = JSON_SERDE.readValue(is, responseFormat);
                is.close();
                HttpResponse<Object> httpResponse = new HttpResponse<Object>(responseCode, connection.getHeaderFields(), result);
                return httpResponse;
            }
            try {
                throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unexpected status code when handling forwarded request: " + responseCode);
            }
            catch (IOException e) {
                log.error("IO error forwarding REST request: ", (Throwable)e);
                throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "IO Error trying to forward REST request: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String urlJoin(String base, String path) {
        if (base.endsWith("/") && path.startsWith("/")) {
            return base + path.substring(1);
        }
        return base + path;
    }

    public static class HttpResponse<T> {
        private int status;
        private Map<String, List<String>> headers;
        private T body;

        public HttpResponse(int status, Map<String, List<String>> headers, T body) {
            this.status = status;
            this.headers = headers;
            this.body = body;
        }

        public int status() {
            return this.status;
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public T body() {
            return this.body;
        }
    }
}

