/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.header;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.header.ConnectHeader;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectHeadersTest {
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_DAYS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_MILLIS;
    private ConnectHeaders headers;
    private Iterator<Header> iter;
    private String key;
    private String other;

    @Before
    public void beforeEach() {
        this.headers = new ConnectHeaders();
        this.key = "k1";
        this.other = "other key";
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullKey() {
        this.headers.add(null, (Object)"value", Schema.STRING_SCHEMA);
    }

    protected void populate(Headers headers) {
        headers.addBoolean(this.key, true);
        headers.addInt(this.key, 0);
        headers.addString(this.other, "other value");
        headers.addString(this.key, null);
        headers.addString(this.key, "third");
    }

    @Test
    public void shouldBeEquals() {
        ConnectHeaders other = new ConnectHeaders();
        Assert.assertEquals((Object)this.headers, (Object)other);
        Assert.assertEquals((long)this.headers.hashCode(), (long)other.hashCode());
        this.populate((Headers)this.headers);
        Assert.assertNotEquals((Object)this.headers, (Object)other);
        Assert.assertNotEquals((long)this.headers.hashCode(), (long)other.hashCode());
        this.populate((Headers)other);
        Assert.assertEquals((Object)this.headers, (Object)other);
        Assert.assertEquals((long)this.headers.hashCode(), (long)other.hashCode());
        this.headers.addString("wow", "some value");
        Assert.assertNotEquals((Object)this.headers, (Object)other);
    }

    @Test
    public void shouldHaveToString() {
        Assert.assertNotNull((Object)this.headers.toString());
        this.populate((Headers)this.headers);
        Assert.assertNotNull((Object)this.headers.toString());
    }

    @Test
    public void shouldRetainLatestWhenEmpty() {
        this.headers.retainLatest(this.other);
        this.headers.retainLatest(this.key);
        this.headers.retainLatest();
        Assert.assertTrue((boolean)this.headers.isEmpty());
    }

    @Test
    public void shouldAddMultipleHeadersWithSameKeyAndRetainLatest() {
        this.populate((Headers)this.headers);
        Header header = this.headers.lastWithName(this.key);
        this.assertHeader(header, this.key, Schema.STRING_SCHEMA, "third");
        this.iter = this.headers.allWithName(this.key);
        this.assertNextHeader(this.iter, this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, this.key, Schema.INT32_SCHEMA, 0);
        this.assertNextHeader(this.iter, this.key, Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertNextHeader(this.iter, this.key, Schema.STRING_SCHEMA, "third");
        this.assertNoNextHeader(this.iter);
        this.iter = this.headers.allWithName(this.other);
        this.assertOnlyNextHeader(this.iter, this.other, Schema.STRING_SCHEMA, "other value");
        this.headers.retainLatest(this.other);
        this.assertOnlySingleHeader(this.other, Schema.STRING_SCHEMA, "other value");
        this.headers.retainLatest(this.key);
        this.assertOnlySingleHeader(this.key, Schema.STRING_SCHEMA, "third");
        this.headers.retainLatest();
        this.assertOnlySingleHeader(this.other, Schema.STRING_SCHEMA, "other value");
        this.assertOnlySingleHeader(this.key, Schema.STRING_SCHEMA, "third");
    }

    @Test
    public void shouldAddHeadersWithPrimitiveValues() {
        String key = "k1";
        this.headers.addBoolean(key, true);
        this.headers.addByte(key, (byte)0);
        this.headers.addShort(key, (short)0);
        this.headers.addInt(key, 0);
        this.headers.addLong(key, 0L);
        this.headers.addFloat(key, 1.0f);
        this.headers.addDouble(key, 1.0);
        this.headers.addString(key, null);
        this.headers.addString(key, "third");
    }

    @Test
    public void shouldAddHeadersWithNullObjectValuesWithOptionalSchema() {
        this.addHeader("k1", Schema.BOOLEAN_SCHEMA, true);
        this.addHeader("k2", Schema.STRING_SCHEMA, "hello");
        this.addHeader("k3", Schema.OPTIONAL_STRING_SCHEMA, null);
    }

    @Test
    public void shouldNotAddHeadersWithNullObjectValuesWithNonOptionalSchema() {
        this.attemptAndFailToAddHeader("k1", Schema.BOOLEAN_SCHEMA, null);
        this.attemptAndFailToAddHeader("k2", Schema.STRING_SCHEMA, null);
    }

    @Test
    public void shouldNotAddHeadersWithObjectValuesAndMismatchedSchema() {
        this.attemptAndFailToAddHeader("k1", Schema.BOOLEAN_SCHEMA, "wrong");
        this.attemptAndFailToAddHeader("k2", Schema.OPTIONAL_STRING_SCHEMA, 0L);
    }

    @Test
    public void shouldRemoveAllHeadersWithSameKeyWhenEmpty() {
        this.headers.remove(this.key);
        this.assertNoHeaderWithKey(this.key);
    }

    @Test
    public void shouldRemoveAllHeadersWithSameKey() {
        this.populate((Headers)this.headers);
        this.iter = this.headers.allWithName(this.key);
        this.assertContainsHeader(this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertContainsHeader(this.key, Schema.INT32_SCHEMA, 0);
        this.assertContainsHeader(this.key, Schema.STRING_SCHEMA, "third");
        this.assertOnlySingleHeader(this.other, Schema.STRING_SCHEMA, "other value");
        this.headers.remove(this.key);
        this.assertNoHeaderWithKey(this.key);
        this.assertOnlySingleHeader(this.other, Schema.STRING_SCHEMA, "other value");
    }

    @Test
    public void shouldRemoveAllHeaders() {
        this.populate((Headers)this.headers);
        this.iter = this.headers.allWithName(this.key);
        this.assertContainsHeader(this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertContainsHeader(this.key, Schema.INT32_SCHEMA, 0);
        this.assertContainsHeader(this.key, Schema.STRING_SCHEMA, "third");
        this.assertOnlySingleHeader(this.other, Schema.STRING_SCHEMA, "other value");
        this.headers.clear();
        this.assertNoHeaderWithKey(this.key);
        this.assertNoHeaderWithKey(this.other);
        Assert.assertEquals((long)0L, (long)this.headers.size());
        Assert.assertTrue((boolean)this.headers.isEmpty());
    }

    @Test
    public void shouldTransformHeadersWhenEmpty() {
        this.headers.apply(this.appendToKey("-suffix"));
        this.headers.apply(this.key, this.appendToKey("-suffix"));
        Assert.assertTrue((boolean)this.headers.isEmpty());
    }

    @Test
    public void shouldTransformHeaders() {
        this.populate((Headers)this.headers);
        this.iter = this.headers.allWithName(this.key);
        this.assertNextHeader(this.iter, this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, this.key, Schema.INT32_SCHEMA, 0);
        this.assertNextHeader(this.iter, this.key, Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertNextHeader(this.iter, this.key, Schema.STRING_SCHEMA, "third");
        this.assertNoNextHeader(this.iter);
        this.iter = this.headers.allWithName(this.other);
        this.assertOnlyNextHeader(this.iter, this.other, Schema.STRING_SCHEMA, "other value");
        Assert.assertEquals((long)5L, (long)this.headers.size());
        this.headers.apply(this.appendToKey("-suffix"));
        Assert.assertEquals((long)5L, (long)this.headers.size());
        this.assertNoHeaderWithKey(this.key);
        this.assertNoHeaderWithKey(this.other);
        String altKey = this.key + "-suffix";
        this.iter = this.headers.allWithName(altKey);
        this.assertNextHeader(this.iter, altKey, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, altKey, Schema.INT32_SCHEMA, 0);
        this.assertNextHeader(this.iter, altKey, Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertNextHeader(this.iter, altKey, Schema.STRING_SCHEMA, "third");
        this.assertNoNextHeader(this.iter);
        this.iter = this.headers.allWithName(this.other + "-suffix");
        this.assertOnlyNextHeader(this.iter, this.other + "-suffix", Schema.STRING_SCHEMA, "other value");
    }

    @Test
    public void shouldTransformHeadersWithKey() {
        this.populate((Headers)this.headers);
        this.iter = this.headers.allWithName(this.key);
        this.assertNextHeader(this.iter, this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, this.key, Schema.INT32_SCHEMA, 0);
        this.assertNextHeader(this.iter, this.key, Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertNextHeader(this.iter, this.key, Schema.STRING_SCHEMA, "third");
        this.assertNoNextHeader(this.iter);
        this.iter = this.headers.allWithName(this.other);
        this.assertOnlyNextHeader(this.iter, this.other, Schema.STRING_SCHEMA, "other value");
        Assert.assertEquals((long)5L, (long)this.headers.size());
        this.headers.apply(this.key, this.appendToKey("-suffix"));
        Assert.assertEquals((long)5L, (long)this.headers.size());
        this.assertNoHeaderWithKey(this.key);
        String altKey = this.key + "-suffix";
        this.iter = this.headers.allWithName(altKey);
        this.assertNextHeader(this.iter, altKey, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, altKey, Schema.INT32_SCHEMA, 0);
        this.assertNextHeader(this.iter, altKey, Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertNextHeader(this.iter, altKey, Schema.STRING_SCHEMA, "third");
        this.assertNoNextHeader(this.iter);
        this.iter = this.headers.allWithName(this.other);
        this.assertOnlyNextHeader(this.iter, this.other, Schema.STRING_SCHEMA, "other value");
    }

    @Test
    public void shouldTransformAndRemoveHeaders() {
        this.populate((Headers)this.headers);
        this.iter = this.headers.allWithName(this.key);
        this.assertNextHeader(this.iter, this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, this.key, Schema.INT32_SCHEMA, 0);
        this.assertNextHeader(this.iter, this.key, Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertNextHeader(this.iter, this.key, Schema.STRING_SCHEMA, "third");
        this.assertNoNextHeader(this.iter);
        this.iter = this.headers.allWithName(this.other);
        this.assertOnlyNextHeader(this.iter, this.other, Schema.STRING_SCHEMA, "other value");
        Assert.assertEquals((long)5L, (long)this.headers.size());
        this.headers.apply(this.key, this.removeHeadersOfType(Schema.Type.STRING));
        Assert.assertEquals((long)3L, (long)this.headers.size());
        this.iter = this.headers.allWithName(this.key);
        this.assertNextHeader(this.iter, this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, this.key, Schema.INT32_SCHEMA, 0);
        this.assertNoNextHeader(this.iter);
        this.assertHeader(this.headers.lastWithName(this.key), this.key, Schema.INT32_SCHEMA, 0);
        this.iter = this.headers.allWithName(this.other);
        this.assertOnlyNextHeader(this.iter, this.other, Schema.STRING_SCHEMA, "other value");
        Assert.assertEquals((long)3L, (long)this.headers.size());
        this.headers.apply(this.removeHeadersOfType(Schema.Type.STRING));
        Assert.assertEquals((long)2L, (long)this.headers.size());
        this.assertNoHeaderWithKey(this.other);
        this.iter = this.headers.allWithName(this.key);
        this.assertNextHeader(this.iter, this.key, Schema.BOOLEAN_SCHEMA, true);
        this.assertNextHeader(this.iter, this.key, Schema.INT32_SCHEMA, 0);
        this.assertNoNextHeader(this.iter);
    }

    protected Headers.HeaderTransform appendToKey(final String suffix) {
        return new Headers.HeaderTransform(){

            public Header apply(Header header) {
                return header.rename(header.key() + suffix);
            }
        };
    }

    protected Headers.HeaderTransform removeHeadersOfType(final Schema.Type type) {
        return new Headers.HeaderTransform(){

            public Header apply(Header header) {
                Schema schema = header.schema();
                if (schema != null && schema.type() == type) {
                    return null;
                }
                return header;
            }
        };
    }

    @Test
    public void shouldValidateBuildInTypes() {
        this.assertSchemaMatches(Schema.OPTIONAL_BOOLEAN_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_BYTES_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_INT8_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_INT16_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_INT32_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_INT64_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_FLOAT32_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_FLOAT64_SCHEMA, null);
        this.assertSchemaMatches(Schema.OPTIONAL_STRING_SCHEMA, null);
        this.assertSchemaMatches(Schema.BOOLEAN_SCHEMA, true);
        this.assertSchemaMatches(Schema.BYTES_SCHEMA, new byte[0]);
        this.assertSchemaMatches(Schema.INT8_SCHEMA, (byte)0);
        this.assertSchemaMatches(Schema.INT16_SCHEMA, (short)0);
        this.assertSchemaMatches(Schema.INT32_SCHEMA, 0);
        this.assertSchemaMatches(Schema.INT64_SCHEMA, 0L);
        this.assertSchemaMatches(Schema.FLOAT32_SCHEMA, Float.valueOf(1.0f));
        this.assertSchemaMatches(Schema.FLOAT64_SCHEMA, 1.0);
        this.assertSchemaMatches(Schema.STRING_SCHEMA, "value");
        this.assertSchemaMatches((Schema)SchemaBuilder.array((Schema)Schema.STRING_SCHEMA), new ArrayList());
        this.assertSchemaMatches((Schema)SchemaBuilder.array((Schema)Schema.STRING_SCHEMA), Collections.singletonList("value"));
        this.assertSchemaMatches((Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA), new HashMap());
        this.assertSchemaMatches((Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA), Collections.singletonMap("a", 0));
        SchemaBuilder emptyStructSchema = SchemaBuilder.struct();
        this.assertSchemaMatches((Schema)emptyStructSchema, new Struct((Schema)emptyStructSchema));
        Schema structSchema = SchemaBuilder.struct().field("foo", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("bar", Schema.STRING_SCHEMA).schema();
        this.assertSchemaMatches(structSchema, new Struct(structSchema).put("foo", (Object)true).put("bar", (Object)"v"));
    }

    @Test
    public void shouldValidateLogicalTypes() {
        this.assertSchemaMatches(Decimal.schema((int)3), new BigDecimal(100.0));
        this.assertSchemaMatches(Time.SCHEMA, new Date());
        this.assertSchemaMatches(org.apache.kafka.connect.data.Date.SCHEMA, new Date());
        this.assertSchemaMatches(Timestamp.SCHEMA, new Date());
    }

    @Test
    public void shouldNotValidateNullValuesWithBuiltInTypes() {
        this.assertSchemaDoesNotMatch(Schema.BOOLEAN_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.BYTES_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.INT8_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.INT16_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.INT32_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.INT64_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.FLOAT32_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.FLOAT64_SCHEMA, null);
        this.assertSchemaDoesNotMatch(Schema.STRING_SCHEMA, null);
        this.assertSchemaDoesNotMatch((Schema)SchemaBuilder.array((Schema)Schema.STRING_SCHEMA), null);
        this.assertSchemaDoesNotMatch((Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA), null);
        this.assertSchemaDoesNotMatch((Schema)SchemaBuilder.struct(), null);
    }

    @Test
    public void shouldNotValidateMismatchedValuesWithBuiltInTypes() {
        this.assertSchemaDoesNotMatch(Schema.BOOLEAN_SCHEMA, 0L);
        this.assertSchemaDoesNotMatch(Schema.BYTES_SCHEMA, "oops");
        this.assertSchemaDoesNotMatch(Schema.INT8_SCHEMA, Float.valueOf(1.0f));
        this.assertSchemaDoesNotMatch(Schema.INT16_SCHEMA, Float.valueOf(1.0f));
        this.assertSchemaDoesNotMatch(Schema.INT32_SCHEMA, 0L);
        this.assertSchemaDoesNotMatch(Schema.INT64_SCHEMA, Float.valueOf(1.0f));
        this.assertSchemaDoesNotMatch(Schema.FLOAT32_SCHEMA, 1L);
        this.assertSchemaDoesNotMatch(Schema.FLOAT64_SCHEMA, 1L);
        this.assertSchemaDoesNotMatch(Schema.STRING_SCHEMA, true);
        this.assertSchemaDoesNotMatch((Schema)SchemaBuilder.array((Schema)Schema.STRING_SCHEMA), "value");
        this.assertSchemaDoesNotMatch((Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA), "value");
        this.assertSchemaDoesNotMatch((Schema)SchemaBuilder.struct(), new ArrayList());
    }

    @Test
    public void shouldAddDate() {
        Date dateObj = EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime();
        int days = org.apache.kafka.connect.data.Date.fromLogical((Schema)org.apache.kafka.connect.data.Date.SCHEMA, (Date)dateObj);
        this.headers.addDate(this.key, dateObj);
        Header header = this.headers.lastWithName(this.key);
        Assert.assertEquals((long)days, (long)Values.convertToInteger((Schema)header.schema(), (Object)header.value()).intValue());
        Assert.assertSame((Object)dateObj, (Object)Values.convertToDate((Schema)header.schema(), (Object)header.value()));
        this.headers.addInt(this.other, days);
        header = this.headers.lastWithName(this.other);
        Assert.assertEquals((long)days, (long)Values.convertToInteger((Schema)header.schema(), (Object)header.value()).intValue());
        Assert.assertEquals((Object)dateObj, (Object)Values.convertToDate((Schema)header.schema(), (Object)header.value()));
    }

    @Test
    public void shouldAddTime() {
        Date dateObj = EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime();
        long millis = Time.fromLogical((Schema)Time.SCHEMA, (Date)dateObj);
        this.headers.addTime(this.key, dateObj);
        Header header = this.headers.lastWithName(this.key);
        Assert.assertEquals((long)millis, (long)Values.convertToLong((Schema)header.schema(), (Object)header.value()));
        Assert.assertSame((Object)dateObj, (Object)Values.convertToTime((Schema)header.schema(), (Object)header.value()));
        this.headers.addLong(this.other, millis);
        header = this.headers.lastWithName(this.other);
        Assert.assertEquals((long)millis, (long)Values.convertToLong((Schema)header.schema(), (Object)header.value()));
        Assert.assertEquals((Object)dateObj, (Object)Values.convertToTime((Schema)header.schema(), (Object)header.value()));
    }

    @Test
    public void shouldAddTimestamp() {
        Date dateObj = EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime();
        long millis = Timestamp.fromLogical((Schema)Timestamp.SCHEMA, (Date)dateObj);
        this.headers.addTimestamp(this.key, dateObj);
        Header header = this.headers.lastWithName(this.key);
        Assert.assertEquals((long)millis, (long)Values.convertToLong((Schema)header.schema(), (Object)header.value()));
        Assert.assertSame((Object)dateObj, (Object)Values.convertToTimestamp((Schema)header.schema(), (Object)header.value()));
        this.headers.addLong(this.other, millis);
        header = this.headers.lastWithName(this.other);
        Assert.assertEquals((long)millis, (long)Values.convertToLong((Schema)header.schema(), (Object)header.value()));
        Assert.assertEquals((Object)dateObj, (Object)Values.convertToTimestamp((Schema)header.schema(), (Object)header.value()));
    }

    @Test
    public void shouldAddDecimal() {
        BigDecimal value = new BigDecimal("3.038573478e+3");
        this.headers.addDecimal(this.key, value);
        Header header = this.headers.lastWithName(this.key);
        Assert.assertEquals((double)value.doubleValue(), (double)Values.convertToDouble((Schema)header.schema(), (Object)header.value()), (double)1.0E-5);
        Assert.assertEquals((Object)value, (Object)Values.convertToDecimal((Schema)header.schema(), (Object)header.value(), (int)value.scale()));
        value = value.setScale(3, RoundingMode.DOWN);
        BigDecimal decimal = Values.convertToDecimal((Schema)header.schema(), (Object)header.value(), (int)value.scale());
        Assert.assertEquals((Object)value, (Object)decimal.setScale(value.scale(), RoundingMode.DOWN));
    }

    @Test
    public void shouldDuplicateAndAlwaysReturnEquivalentButDifferentObject() {
        Assert.assertEquals((Object)this.headers, (Object)this.headers.duplicate());
        Assert.assertNotSame((Object)this.headers, (Object)this.headers.duplicate());
    }

    protected void assertSchemaMatches(Schema schema, Object value) {
        this.headers.checkSchemaMatches(new SchemaAndValue(schema.schema(), value));
    }

    protected void assertSchemaDoesNotMatch(Schema schema, Object value) {
        try {
            this.assertSchemaMatches(schema, value);
            Assert.fail((String)("Should have failed to validate value '" + value + "' and schema: " + schema));
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    protected void attemptAndFailToAddHeader(String key, Schema schema, Object value) {
        try {
            this.headers.add(key, value, schema);
            Assert.fail((String)("Should have failed to add header with key '" + key + "', value '" + value + "', and schema: " + schema));
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    protected void addHeader(String key, Schema schema, Object value) {
        this.headers.add(key, value, schema);
        Header header = this.headers.lastWithName(key);
        Assert.assertNotNull((Object)header);
        this.assertHeader(header, key, schema, value);
    }

    protected void assertNoHeaderWithKey(String key) {
        this.assertNoNextHeader(this.headers.allWithName(key));
    }

    protected void assertContainsHeader(String key, Schema schema, Object value) {
        ConnectHeader expected = new ConnectHeader(key, new SchemaAndValue(schema, value));
        Iterator iter = this.headers.allWithName(key);
        while (iter.hasNext()) {
            Header header = (Header)iter.next();
            if (!header.equals(expected)) continue;
            return;
        }
        Assert.fail((String)("Should have found header " + expected));
    }

    protected void assertOnlySingleHeader(String key, Schema schema, Object value) {
        this.assertOnlyNextHeader(this.headers.allWithName(key), key, schema, value);
    }

    protected void assertOnlyNextHeader(Iterator<Header> iter, String key, Schema schema, Object value) {
        this.assertNextHeader(iter, key, schema, value);
        this.assertNoNextHeader(iter);
    }

    protected void assertNextHeader(Iterator<Header> iter, String key, Schema schema, Object value) {
        Header header = iter.next();
        this.assertHeader(header, key, schema, value);
    }

    protected void assertNoNextHeader(Iterator<Header> iter) {
        Assert.assertFalse((boolean)iter.hasNext());
    }

    protected void assertHeader(Header header, String key, Schema schema, Object value) {
        Assert.assertNotNull((Object)header);
        Assert.assertSame((Object)schema, (Object)header.schema());
        Assert.assertSame((Object)value, (Object)header.value());
    }

    static {
        EPOCH_PLUS_TEN_THOUSAND_DAYS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_DAYS.add(5, 10000);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.add(14, 10000);
    }
}

