/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;

public class StructTest {
    private static final Schema FLAT_STRUCT_SCHEMA = SchemaBuilder.struct().field("int8", Schema.INT8_SCHEMA).field("int16", Schema.INT16_SCHEMA).field("int32", Schema.INT32_SCHEMA).field("int64", Schema.INT64_SCHEMA).field("float32", Schema.FLOAT32_SCHEMA).field("float64", Schema.FLOAT64_SCHEMA).field("boolean", Schema.BOOLEAN_SCHEMA).field("string", Schema.STRING_SCHEMA).field("bytes", Schema.BYTES_SCHEMA).build();
    private static final Schema ARRAY_SCHEMA = SchemaBuilder.array((Schema)Schema.INT8_SCHEMA).build();
    private static final Schema MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.STRING_SCHEMA).build();
    private static final Schema NESTED_CHILD_SCHEMA = SchemaBuilder.struct().field("int8", Schema.INT8_SCHEMA).build();
    private static final Schema NESTED_SCHEMA = SchemaBuilder.struct().field("array", ARRAY_SCHEMA).field("map", MAP_SCHEMA).field("nested", NESTED_CHILD_SCHEMA).build();
    private static final Schema REQUIRED_FIELD_SCHEMA = Schema.INT8_SCHEMA;
    private static final Schema OPTIONAL_FIELD_SCHEMA = SchemaBuilder.int8().optional().build();
    private static final Schema DEFAULT_FIELD_SCHEMA = SchemaBuilder.int8().defaultValue((Object)0).build();

    @Test
    public void testFlatStruct() {
        Struct struct = new Struct(FLAT_STRUCT_SCHEMA).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.0f)).put("float64", (Object)12.0).put("boolean", (Object)true).put("string", (Object)"foobar").put("bytes", (Object)"foobar".getBytes());
        Assert.assertEquals((long)12L, (long)struct.getInt8("int8").byteValue());
        Assert.assertEquals((long)12L, (long)struct.getInt16("int16").shortValue());
        Assert.assertEquals((long)12L, (long)struct.getInt32("int32").intValue());
        Assert.assertEquals((long)12L, (long)struct.getInt64("int64"));
        Assert.assertEquals((Object)Float.valueOf(12.0f), (Object)struct.getFloat32("float32"));
        Assert.assertEquals((Object)12.0, (Object)struct.getFloat64("float64"));
        Assert.assertEquals((Object)true, (Object)struct.getBoolean("boolean"));
        Assert.assertEquals((Object)"foobar", (Object)struct.getString("string"));
        Assert.assertEquals((Object)ByteBuffer.wrap("foobar".getBytes()), (Object)ByteBuffer.wrap(struct.getBytes("bytes")));
        struct.validate();
    }

    @Test
    public void testComplexStruct() {
        List<Byte> array = Arrays.asList((byte)1, (byte)2);
        Map<Integer, String> map = Collections.singletonMap(1, "string");
        Struct struct = new Struct(NESTED_SCHEMA).put("array", array).put("map", map).put("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).put("int8", (Object)12));
        List arrayExtracted = struct.getArray("array");
        Assert.assertEquals(array, (Object)arrayExtracted);
        Map mapExtracted = struct.getMap("map");
        Assert.assertEquals(map, (Object)mapExtracted);
        Assert.assertEquals((Object)12, (Object)struct.getStruct("nested").get("int8"));
        struct.validate();
    }

    @Test(expected=DataException.class)
    public void testInvalidFieldType() {
        new Struct(FLAT_STRUCT_SCHEMA).put("int8", (Object)"should fail because this is a string, not int8");
    }

    @Test(expected=DataException.class)
    public void testInvalidArrayFieldElements() {
        new Struct(NESTED_SCHEMA).put("array", Arrays.asList("should fail since elements should be int8s"));
    }

    @Test(expected=DataException.class)
    public void testInvalidMapKeyElements() {
        new Struct(NESTED_SCHEMA).put("map", Collections.singletonMap("should fail because keys should be int8s", (byte)12));
    }

    @Test(expected=DataException.class)
    public void testInvalidStructFieldSchema() {
        new Struct(NESTED_SCHEMA).put("nested", (Object)new Struct(MAP_SCHEMA));
    }

    @Test(expected=DataException.class)
    public void testInvalidStructFieldValue() {
        new Struct(NESTED_SCHEMA).put("nested", (Object)new Struct(NESTED_CHILD_SCHEMA));
    }

    @Test(expected=DataException.class)
    public void testMissingFieldValidation() {
        Schema schema = SchemaBuilder.struct().field("field", REQUIRED_FIELD_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.validate();
    }

    @Test
    public void testMissingOptionalFieldValidation() {
        Schema schema = SchemaBuilder.struct().field("field", OPTIONAL_FIELD_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.validate();
    }

    @Test
    public void testMissingFieldWithDefaultValidation() {
        Schema schema = SchemaBuilder.struct().field("field", DEFAULT_FIELD_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.validate();
    }

    @Test
    public void testEquals() {
        Struct struct1 = new Struct(FLAT_STRUCT_SCHEMA).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.0f)).put("float64", (Object)12.0).put("boolean", (Object)true).put("string", (Object)"foobar").put("bytes", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Struct struct2 = new Struct(FLAT_STRUCT_SCHEMA).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.0f)).put("float64", (Object)12.0).put("boolean", (Object)true).put("string", (Object)"foobar").put("bytes", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Struct struct3 = new Struct(FLAT_STRUCT_SCHEMA).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.0f)).put("float64", (Object)12.0).put("boolean", (Object)true).put("string", (Object)"mismatching string").put("bytes", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Assert.assertEquals((Object)struct1, (Object)struct2);
        Assert.assertNotEquals((Object)struct1, (Object)struct3);
        List<Byte> array = Arrays.asList((byte)1, (byte)2);
        Map<Integer, String> map = Collections.singletonMap(1, "string");
        struct1 = new Struct(NESTED_SCHEMA).put("array", array).put("map", map).put("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).put("int8", (Object)12));
        List<Byte> array2 = Arrays.asList((byte)1, (byte)2);
        Map<Integer, String> map2 = Collections.singletonMap(1, "string");
        struct2 = new Struct(NESTED_SCHEMA).put("array", array2).put("map", map2).put("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).put("int8", (Object)12));
        List<Byte> array3 = Arrays.asList((byte)1, (byte)2, (byte)3);
        Map<Integer, String> map3 = Collections.singletonMap(2, "string");
        struct3 = new Struct(NESTED_SCHEMA).put("array", array3).put("map", map3).put("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).put("int8", (Object)13));
        Assert.assertEquals((Object)struct1, (Object)struct2);
        Assert.assertNotEquals((Object)struct1, (Object)struct3);
    }
}

