/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.DataException;

public class Time {
    public static final String LOGICAL_NAME = "org.apache.kafka.connect.data.Time";
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final Schema SCHEMA = Time.builder().schema();

    public static SchemaBuilder builder() {
        return SchemaBuilder.int32().name(LOGICAL_NAME).version(1);
    }

    public static int fromLogical(Schema schema, Date value) {
        if (schema.name() == null || !schema.name().equals(LOGICAL_NAME)) {
            throw new DataException("Requested conversion of Time object but the schema does not match.");
        }
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTime(value);
        long unixMillis = calendar.getTimeInMillis();
        if (unixMillis < 0L || unixMillis > 86400000L) {
            throw new DataException("Kafka Connect Time type should not have any date fields set to non-zero values.");
        }
        return (int)unixMillis;
    }

    public static Date toLogical(Schema schema, int value) {
        if (schema.name() == null || !schema.name().equals(LOGICAL_NAME)) {
            throw new DataException("Requested conversion of Date object but the schema does not match.");
        }
        if (value < 0 || (long)value > 86400000L) {
            throw new DataException("Time values must use number of milliseconds greater than 0 and less than 86400000");
        }
        return new Date(value);
    }
}

