/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import junit.framework.Assert;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.w3._2000._09.xmldsig_.CanonicalizationMethodType;
import org.w3._2000._09.xmldsig_.DigestMethodType;
import org.w3._2000._09.xmldsig_.KeyInfoType;
import org.w3._2000._09.xmldsig_.ObjectType;
import org.w3._2000._09.xmldsig_.ReferenceType;
import org.w3._2000._09.xmldsig_.SignatureMethodType;
import org.w3._2000._09.xmldsig_.SignatureType;
import org.w3._2000._09.xmldsig_.SignatureValueType;
import org.w3._2000._09.xmldsig_.SignedInfoType;
import org.w3._2000._09.xmldsig_.TransformType;
import org.w3._2000._09.xmldsig_.TransformsType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TckValidator {
    public static void checkNames(List<Name> names1, List<Name> names2) {
        if (names1 == null || names2 == null) {
            Assert.assertEquals(names1, names2);
            return;
        }
        Assert.assertEquals((int)names1.size(), (int)names2.size());
        Iterator<Name> names1Itr = names1.iterator();
        Iterator<Name> names2Itr = names2.iterator();
        while (names1Itr.hasNext()) {
            Name name1 = names1Itr.next();
            Name name2 = names2Itr.next();
            Assert.assertEquals((String)name1.getLang(), (String)name2.getLang());
            Assert.assertEquals((String)name1.getValue(), (String)name2.getValue());
        }
    }

    public static void checkDescriptions(List<Description> descriptions1, List<Description> descriptions2) {
        if (descriptions1 == null || descriptions2 == null) {
            Assert.assertEquals(descriptions1, descriptions2);
            return;
        }
        Assert.assertEquals((int)descriptions1.size(), (int)descriptions2.size());
        Iterator<Description> descriptions1Itr = descriptions1.iterator();
        Iterator<Description> descriptions2Itr = descriptions2.iterator();
        while (descriptions1Itr.hasNext()) {
            Description description1 = descriptions1Itr.next();
            Description description2 = descriptions2Itr.next();
            Assert.assertEquals((String)description1.getLang(), (String)description2.getLang());
            Assert.assertEquals((String)description1.getValue(), (String)description2.getValue());
        }
    }

    public static void checkDiscoveryUrls(DiscoveryURLs discs1, DiscoveryURLs discs2) {
        if (discs1 == null || discs2 == null) {
            Assert.assertEquals((Object)discs1, (Object)discs2);
            return;
        }
        List discList1 = discs1.getDiscoveryURL();
        List discList2 = discs2.getDiscoveryURL();
        if (discList1 == null || discList2 == null) {
            Assert.assertEquals((Object)discList1, (Object)discList2);
            return;
        }
        Assert.assertEquals((int)discList1.size(), (int)discList2.size());
        Iterator discList1Itr = discList1.iterator();
        Iterator discList2Itr = discList2.iterator();
        while (discList1Itr.hasNext()) {
            DiscoveryURL disc1 = (DiscoveryURL)discList1Itr.next();
            DiscoveryURL disc2 = (DiscoveryURL)discList2Itr.next();
            Assert.assertEquals((String)disc1.getUseType(), (String)disc2.getUseType());
            Assert.assertEquals((String)disc1.getValue(), (String)disc2.getValue());
        }
    }

    public static void checkSignatures(List<SignatureType> sigs1, List<SignatureType> sigs2) {
        if (sigs1 == null || sigs2 == null) {
            Assert.assertEquals(sigs1, sigs2);
            return;
        }
        Assert.assertEquals((int)sigs1.size(), (int)sigs2.size());
        Iterator<SignatureType> sigsList1Itr = sigs1.iterator();
        Iterator<SignatureType> sigsList2Itr = sigs2.iterator();
        while (sigsList1Itr.hasNext()) {
            SignatureType sig1 = sigsList1Itr.next();
            SignatureType sig2 = sigsList2Itr.next();
            Assert.assertEquals((String)sig1.getId(), (String)sig2.getId());
            TckValidator.checkKeyInfo(sig1.getKeyInfo(), sig2.getKeyInfo());
            TckValidator.checkObjectType(sig1.getObject(), sig2.getObject());
            TckValidator.checkSignatureValue(sig1.getSignatureValue(), sig2.getSignatureValue());
            TckValidator.checkSignedInfo(sig1.getSignedInfo(), sig2.getSignedInfo());
        }
    }

    public static void checkKeyInfo(KeyInfoType kit1, KeyInfoType kit2) {
        if (kit1 == null || kit2 == null) {
            Assert.assertEquals((Object)kit1, (Object)kit2);
            return;
        }
        Assert.assertEquals((String)kit1.getId(), (String)kit2.getId());
        DOMResult domResult1 = new DOMResult();
        DOMResult domResult2 = new DOMResult();
        JAXB.marshal((Object)kit1, (Result)domResult1);
        JAXB.marshal((Object)kit2, (Result)domResult2);
        Document doc1 = (Document)domResult1.getNode();
        DOMSource domSource1 = new DOMSource(doc1.getDocumentElement());
        Document doc2 = (Document)domResult2.getNode();
        DOMSource domSource2 = new DOMSource(doc2.getDocumentElement());
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff diff = new Diff(domSource1, domSource2);
        Assert.assertTrue((String)"Key info elements should match", (boolean)diff.similar());
    }

    public static void checkObjectType(List<ObjectType> obj1List, List<ObjectType> obj2List) {
        if (obj1List == null || obj2List == null) {
            Assert.assertEquals(obj1List, obj2List);
            return;
        }
        Assert.assertEquals((int)obj1List.size(), (int)obj2List.size());
        Iterator<ObjectType> objList1Itr = obj1List.iterator();
        Iterator<ObjectType> objList2Itr = obj2List.iterator();
        while (objList1Itr.hasNext()) {
            ObjectType obj1 = objList1Itr.next();
            ObjectType obj2 = objList2Itr.next();
            Assert.assertEquals((String)obj1.getEncoding(), (String)obj2.getEncoding());
            Assert.assertEquals((String)obj1.getId(), (String)obj2.getId());
            Assert.assertEquals((String)obj1.getMimeType(), (String)obj2.getMimeType());
        }
    }

    public static void checkSignatureValue(SignatureValueType sv1, SignatureValueType sv2) {
        if (sv1 == null || sv2 == null) {
            Assert.assertEquals((Object)sv1, (Object)sv2);
            return;
        }
        Assert.assertEquals((String)sv1.getId(), (String)sv2.getId());
        Assert.assertTrue((boolean)Arrays.equals(sv1.getValue(), sv2.getValue()));
    }

    public static void checkSignedInfo(SignedInfoType si1, SignedInfoType si2) {
        if (si1 == null || si2 == null) {
            Assert.assertEquals((Object)si1, (Object)si2);
            return;
        }
        Assert.assertEquals((String)si1.getId(), (String)si2.getId());
        TckValidator.checkCanonicalizationMethod(si1.getCanonicalizationMethod(), si2.getCanonicalizationMethod());
        TckValidator.checkReference(si1.getReference(), si2.getReference());
        TckValidator.checkSignatureMethod(si1.getSignatureMethod(), si2.getSignatureMethod());
    }

    public static void checkCanonicalizationMethod(CanonicalizationMethodType cm1, CanonicalizationMethodType cm2) {
        if (cm1 == null || cm2 == null) {
            Assert.assertEquals((Object)cm1, (Object)cm2);
            return;
        }
        Assert.assertEquals((String)cm1.getAlgorithm(), (String)cm2.getAlgorithm());
    }

    public static void checkReference(List<ReferenceType> r1List, List<ReferenceType> r2List) {
        if (r1List == null || r2List == null) {
            Assert.assertEquals(r1List, r2List);
            return;
        }
        Assert.assertEquals((int)r1List.size(), (int)r2List.size());
        Iterator<ReferenceType> rList1Itr = r1List.iterator();
        Iterator<ReferenceType> rList2Itr = r2List.iterator();
        while (rList1Itr.hasNext()) {
            ReferenceType r1 = rList1Itr.next();
            ReferenceType r2 = rList2Itr.next();
            TckValidator.checkReference(r1, r2);
        }
    }

    public static void checkReference(ReferenceType r1, ReferenceType r2) {
        Assert.assertTrue((boolean)Arrays.equals(r1.getDigestValue(), r2.getDigestValue()));
        Assert.assertEquals((String)r1.getId(), (String)r2.getId());
        Assert.assertEquals((String)r1.getType(), (String)r2.getType());
        Assert.assertEquals((String)r1.getURI(), (String)r2.getURI());
        TckValidator.checkDigestMethod(r1.getDigestMethod(), r2.getDigestMethod());
        TckValidator.checkTransforms(r1.getTransforms(), r2.getTransforms());
    }

    public static void checkDigestMethod(DigestMethodType dm1, DigestMethodType dm2) {
        if (dm1 == null || dm2 == null) {
            Assert.assertEquals((Object)dm1, (Object)dm2);
            return;
        }
        Assert.assertEquals((String)dm1.getAlgorithm(), (String)dm2.getAlgorithm());
    }

    public static void checkTransforms(TransformsType tTypes1, TransformsType tTypes2) {
        if (tTypes1 == null || tTypes2 == null) {
            Assert.assertEquals((Object)tTypes1, (Object)tTypes2);
            return;
        }
        List tt1List = tTypes1.getTransform();
        List tt2List = tTypes2.getTransform();
        if (tt1List == null || tt2List == null) {
            Assert.assertEquals((Object)tt1List, (Object)tt2List);
            return;
        }
        Assert.assertEquals((int)tt1List.size(), (int)tt2List.size());
        Iterator ttList1Itr = tt1List.iterator();
        Iterator ttList2Itr = tt2List.iterator();
        while (ttList1Itr.hasNext()) {
            TransformType tx1 = (TransformType)ttList1Itr.next();
            TransformType tx2 = (TransformType)ttList2Itr.next();
            Assert.assertEquals((String)tx1.getAlgorithm(), (String)tx2.getAlgorithm());
            TckValidator.checkTransformContentList(tx1.getContent(), tx2.getContent());
        }
    }

    public static void checkTransformContentList(List<Object> list1, List<Object> list2) {
        if (list1 == null || list2 == null) {
            Assert.assertEquals(list1, list2);
            return;
        }
        Assert.assertEquals((int)list1.size(), (int)list2.size());
        Iterator<Object> list1Itr = list1.iterator();
        Iterator<Object> list2Itr = list2.iterator();
        while (list1Itr.hasNext()) {
            Object obj1 = list1Itr.next();
            Object obj2 = list2Itr.next();
            if (obj1 instanceof String) {
                Assert.assertEquals((Object)((String)obj1), (Object)obj2);
                continue;
            }
            if (obj1 instanceof Element || obj1 instanceof JAXBElement) {
                DOMResult domResult;
                if (obj1 instanceof JAXBElement) {
                    domResult = new DOMResult();
                    JAXB.marshal((Object)obj1, (Result)domResult);
                    obj1 = ((Document)domResult.getNode()).getDocumentElement();
                }
                if (obj2 instanceof JAXBElement) {
                    domResult = new DOMResult();
                    JAXB.marshal((Object)obj2, (Result)domResult);
                    obj2 = ((Document)domResult.getNode()).getDocumentElement();
                }
                XMLUnit.setIgnoreAttributeOrder((boolean)true);
                XMLUnit.setIgnoreComments((boolean)true);
                DOMSource domSrc1 = new DOMSource((Element)obj1);
                DOMSource domSrc2 = new DOMSource((Element)obj2);
                Diff diff = new Diff(domSrc1, domSrc2);
                Assert.assertTrue((String)"Element should be the same", (boolean)diff.similar());
                continue;
            }
            throw new RuntimeException("Unrecognized type: " + obj1.getClass());
        }
    }

    public static void checkSignatureMethod(SignatureMethodType smt1, SignatureMethodType smt2) {
        if (smt1 == null || smt2 == null) {
            Assert.assertEquals((Object)smt1, (Object)smt2);
            return;
        }
        Assert.assertEquals((String)smt1.getAlgorithm(), (String)smt2.getAlgorithm());
    }

    public static void checkContacts(Contacts contacts1, Contacts contacts2) {
        if (contacts1 == null || contacts2 == null) {
            Assert.assertEquals((Object)contacts1, (Object)contacts2);
            return;
        }
        List contactList1 = contacts1.getContact();
        List contactList2 = contacts2.getContact();
        if (contactList1 == null || contactList2 == null) {
            Assert.assertEquals((Object)contactList1, (Object)contactList2);
            return;
        }
        Assert.assertEquals((int)contactList1.size(), (int)contactList2.size());
        Iterator contactList1Itr = contactList1.iterator();
        Iterator contactList2Itr = contactList2.iterator();
        while (contactList1Itr.hasNext()) {
            Contact contact1 = (Contact)contactList1Itr.next();
            Contact contact2 = (Contact)contactList2Itr.next();
            Assert.assertEquals((String)contact1.getUseType(), (String)contact2.getUseType());
            TckValidator.checkPersonNames(contact1.getPersonName(), contact2.getPersonName());
            TckValidator.checkDescriptions(contact1.getDescription(), contact2.getDescription());
        }
    }

    public static void checkPersonNames(List<PersonName> names1, List<PersonName> names2) {
        if (names1 == null || names2 == null) {
            Assert.assertEquals(names1, names2);
            return;
        }
        Assert.assertEquals((int)names1.size(), (int)names2.size());
        Iterator<PersonName> names1Itr = names1.iterator();
        Iterator<PersonName> names2Itr = names2.iterator();
        while (names1Itr.hasNext()) {
            PersonName name1 = names1Itr.next();
            PersonName name2 = names2Itr.next();
            Assert.assertEquals((String)name1.getLang(), (String)name2.getLang());
            Assert.assertEquals((String)name1.getValue(), (String)name2.getValue());
        }
    }

    public static void checkCategories(CategoryBag cbag1, CategoryBag cbag2) {
        if (cbag1 == null || cbag2 == null) {
            Assert.assertEquals((Object)cbag1, (Object)cbag2);
            return;
        }
        List elemList1 = cbag1.getKeyedReference();
        List elemList2 = cbag2.getKeyedReference();
        if (elemList1 == null || elemList2 == null) {
            Assert.assertEquals((Object)elemList1, (Object)elemList2);
            return;
        }
        Iterator elemList1Itr = elemList1.iterator();
        Iterator elemList2Itr = elemList2.iterator();
        while (elemList1Itr.hasNext()) {
            KeyedReference elem1 = (KeyedReference)elemList1Itr.next();
            if (!(elem1 instanceof KeyedReference)) continue;
            KeyedReference elem2 = (KeyedReference)elemList2Itr.next();
            Assert.assertEquals((String)elem1.getTModelKey(), (String)elem2.getTModelKey());
            Assert.assertEquals((String)elem1.getKeyName(), (String)elem2.getKeyName());
            Assert.assertEquals((String)elem1.getKeyValue(), (String)elem2.getKeyValue());
        }
    }

    public static void checkBindingTemplates(BindingTemplates bts1, BindingTemplates bts2) {
        if (bts1 == null || bts2 == null) {
            Assert.assertEquals((Object)bts1, (Object)bts2);
            return;
        }
        Assert.assertEquals((int)bts1.getBindingTemplate().size(), (int)bts2.getBindingTemplate().size());
        Iterator bt1Iter = bts1.getBindingTemplate().iterator();
        Iterator bt2Iter = bts2.getBindingTemplate().iterator();
        while (bt1Iter.hasNext()) {
            BindingTemplate bt1 = (BindingTemplate)bt1Iter.next();
            BindingTemplate bt2 = (BindingTemplate)bt2Iter.next();
            Assert.assertEquals((String)bt1.getAccessPoint().getValue(), (String)bt2.getAccessPoint().getValue());
            Assert.assertEquals((String)bt1.getAccessPoint().getUseType(), (String)bt2.getAccessPoint().getUseType());
            Assert.assertEquals((String)bt1.getBindingKey().toLowerCase(), (String)bt2.getBindingKey());
            TckValidator.checkCategories(bt1.getCategoryBag(), bt2.getCategoryBag());
            TckValidator.checkDescriptions(bt1.getDescription(), bt2.getDescription());
            TckValidator.checkHostingRedirector(bt1.getHostingRedirector(), bt2.getHostingRedirector());
            if (bt1.getServiceKey() != null) {
                Assert.assertEquals((String)bt1.getServiceKey(), (String)bt2.getServiceKey());
            }
            TckValidator.checkTModelInstanceDetails(bt1.getTModelInstanceDetails(), bt2.getTModelInstanceDetails());
        }
    }

    public static void checkTModelInstanceDetails(TModelInstanceDetails tmds1, TModelInstanceDetails tmds2) {
        if (tmds1 == null || tmds2 == null) {
            Assert.assertEquals((Object)tmds1, (Object)tmds2);
            return;
        }
        Assert.assertEquals((int)tmds1.getTModelInstanceInfo().size(), (int)tmds2.getTModelInstanceInfo().size());
        Iterator tmIter1 = tmds1.getTModelInstanceInfo().iterator();
        Iterator tmIter2 = tmds2.getTModelInstanceInfo().iterator();
        while (tmIter1.hasNext()) {
            TModelInstanceInfo tmI1 = (TModelInstanceInfo)tmIter1.next();
            TModelInstanceInfo tmI2 = (TModelInstanceInfo)tmIter2.next();
            TckValidator.checkDescriptions(tmI1.getDescription(), tmI2.getDescription());
            TckValidator.checkInstanceDetails(tmI1.getInstanceDetails(), tmI2.getInstanceDetails());
            Assert.assertEquals((String)tmI1.getTModelKey().toLowerCase(), (String)tmI2.getTModelKey());
        }
    }

    public static void checkInstanceDetails(InstanceDetails ids1, InstanceDetails ids2) {
        if (ids1 == null || ids2 == null) {
            Assert.assertEquals((Object)ids1, (Object)ids2);
            return;
        }
        List elem1s = ids1.getDescription();
        List elem2s = ids2.getDescription();
        Iterator elem1 = elem1s.iterator();
        boolean isMatch = false;
        if (elem1s.size() == 0 && elem2s.size() == 0) {
            isMatch = true;
        }
        block0: while (elem1.hasNext()) {
            Description desc1 = (Description)elem1.next();
            if (!(desc1 instanceof Description)) continue;
            for (Description desc2 : elem2s) {
                if (!(desc2 instanceof Description) || !desc1.getLang().equals(desc2.getLang()) || !desc1.getValue().equals(desc2.getValue())) continue;
                isMatch = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)isMatch);
        List odoc1s = ids1.getOverviewDoc();
        List odoc2s = ids2.getOverviewDoc();
        Iterator docelem1 = odoc1s.iterator();
        isMatch = false;
        if (odoc1s.size() == 0 && odoc2s.size() == 0) {
            isMatch = true;
        }
        while (docelem1.hasNext()) {
            OverviewDoc odoc1 = (OverviewDoc)docelem1.next();
            if (!(odoc1 instanceof OverviewDoc)) continue;
            TckValidator.checkOverviewDocs(odoc1, odoc2s);
            isMatch = true;
        }
        Assert.assertEquals((String)ids1.getInstanceParms(), (String)ids2.getInstanceParms());
        Assert.assertTrue((boolean)isMatch);
    }

    public static void checkOverviewDocs(OverviewDoc doc1, List<OverviewDoc> elem2s) {
        OverviewDoc doc2;
        boolean isMatch = false;
        Iterator<OverviewDoc> elem2 = elem2s.iterator();
        while (!(!elem2.hasNext() || (doc2 = elem2.next()) instanceof OverviewDoc && (isMatch = TckValidator.compareOverviewDocs(doc1, doc2)))) {
        }
        Assert.assertTrue((boolean)isMatch);
    }

    public static void checkOverviewDocs(OverviewDoc doc1, Collection<OverviewDoc> doc2s) {
        OverviewDoc doc2;
        boolean isMatch = false;
        Iterator<OverviewDoc> docIter = doc2s.iterator();
        while (docIter.hasNext() && !(isMatch = TckValidator.compareOverviewDocs(doc1, doc2 = docIter.next()))) {
        }
        Assert.assertTrue((boolean)isMatch);
    }

    public static boolean compareOverviewDocs(OverviewDoc doc1, OverviewDoc doc2) {
        boolean descMatch = false;
        boolean urlMatch = false;
        OverviewURL url1 = doc1.getOverviewURL();
        OverviewURL url2 = doc2.getOverviewURL();
        if (url1.getUseType().equals(url2.getUseType()) && url1.getValue().trim().equals(url2.getValue().trim())) {
            urlMatch = true;
        }
        List descList1 = doc1.getDescription();
        Iterator descIter1 = descList1.iterator();
        if (descList1.size() == 0 && doc2.getDescription().size() == 0) {
            descMatch = true;
        }
        while (descIter1.hasNext()) {
            Description descr1 = (Description)descIter1.next();
            List descList2 = doc2.getDescription();
            for (Description descr2 : descList2) {
                if (!descr1.getLang().equals(descr2.getLang()) || !descr1.getValue().equals(descr2.getValue())) continue;
                descMatch = true;
            }
        }
        return urlMatch && descMatch;
    }

    public static void checkHostingRedirector(HostingRedirector hr1, HostingRedirector hr2) {
        if (hr1 == null || hr2 == null) {
            Assert.assertEquals((Object)hr1, (Object)hr2);
            return;
        }
        Assert.assertEquals((String)hr1.getBindingKey(), (String)hr2.getBindingKey());
    }
}

