/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.uddi.api_v3.Address;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class TckCommon {
    private static Log logger = LogFactory.getLog(TckCommon.class);

    public static String CatBagToString(CategoryBag categoryBag) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (categoryBag == null) {
            return "no data";
        }
        for (i = 0; i < categoryBag.getKeyedReference().size(); ++i) {
            sb.append(TckCommon.KeyedReferenceToString((KeyedReference)categoryBag.getKeyedReference().get(i)));
        }
        for (i = 0; i < categoryBag.getKeyedReferenceGroup().size(); ++i) {
            sb.append("Key Ref Grp: TModelKey=");
            for (int k = 0; k < ((KeyedReferenceGroup)categoryBag.getKeyedReferenceGroup().get(i)).getKeyedReference().size(); ++k) {
                sb.append(TckCommon.KeyedReferenceToString((KeyedReference)((KeyedReferenceGroup)categoryBag.getKeyedReferenceGroup().get(i)).getKeyedReference().get(k)));
            }
        }
        return sb.toString();
    }

    public static String KeyedReferenceToString(KeyedReference item) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key Ref: Name=").append(item.getKeyName()).append(" Value=").append(item.getKeyValue()).append(" tModel=").append(item.getTModelKey()).append(System.getProperty("line.separator"));
        return sb.toString();
    }

    public static void PrintContacts(Contacts contacts) {
        if (contacts == null) {
            return;
        }
        for (int i = 0; i < contacts.getContact().size(); ++i) {
            int k;
            System.out.println("Contact " + i + " type:" + ((Contact)contacts.getContact().get(i)).getUseType());
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getPersonName().size(); ++k) {
                System.out.println("Name: " + ((PersonName)((Contact)contacts.getContact().get(i)).getPersonName().get(k)).getValue());
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getEmail().size(); ++k) {
                System.out.println("Email: " + ((Email)((Contact)contacts.getContact().get(i)).getEmail().get(k)).getValue());
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getAddress().size(); ++k) {
                System.out.println("Address sort code " + ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getSortCode());
                System.out.println("Address use type " + ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getUseType());
                System.out.println("Address tmodel key " + ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getTModelKey());
                for (int x = 0; x < ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().size(); ++x) {
                    System.out.println("Address line value " + ((AddressLine)((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().get(x)).getValue());
                    System.out.println("Address line key name " + ((AddressLine)((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().get(x)).getKeyName());
                    System.out.println("Address line key value " + ((AddressLine)((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().get(x)).getKeyValue());
                }
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getDescription().size(); ++k) {
                System.out.println("Desc: " + ((Description)((Contact)contacts.getContact().get(i)).getDescription().get(k)).getValue());
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getPhone().size(); ++k) {
                System.out.println("Phone: " + ((Phone)((Contact)contacts.getContact().get(i)).getPhone().get(k)).getValue());
            }
        }
    }

    public static void PrintBindingTemplates(BindingTemplates bindingTemplates) {
        if (bindingTemplates == null) {
            return;
        }
        for (int i = 0; i < bindingTemplates.getBindingTemplate().size(); ++i) {
            System.out.println("Binding Key: " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getBindingKey());
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint() != null) {
                System.out.println("Access Point: " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getValue() + " type " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType());
            }
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getHostingRedirector() == null) continue;
            System.out.println("Hosting Redirection: " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getHostingRedirector().getBindingKey());
        }
    }

    public static void PrintBusinessInfo(BusinessInfos businessInfos) {
        if (businessInfos == null) {
            System.out.println("No data returned");
        } else {
            for (int i = 0; i < businessInfos.getBusinessInfo().size(); ++i) {
                System.out.println("===============================================");
                System.out.println("Business Key: " + ((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getBusinessKey());
                System.out.println("Name: " + TckCommon.ListToString(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getName()));
                System.out.println("Name: " + TckCommon.ListToDescString(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getDescription()));
                System.out.println("Services:");
                TckCommon.PrintServiceInfo(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getServiceInfos());
            }
        }
    }

    public static String ListToString(List<Name> name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.size(); ++i) {
            sb.append(name.get(i).getValue()).append(" ");
        }
        return sb.toString();
    }

    public static String ListToDescString(List<Description> name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.size(); ++i) {
            sb.append(name.get(i).getValue()).append(" ");
        }
        return sb.toString();
    }

    public static void PrintServiceInfo(ServiceInfos serviceInfos) {
        for (int i = 0; i < serviceInfos.getServiceInfo().size(); ++i) {
            System.out.println("-------------------------------------------");
            System.out.println("Service Key: " + ((ServiceInfo)serviceInfos.getServiceInfo().get(i)).getServiceKey());
            System.out.println("Owning Business Key: " + ((ServiceInfo)serviceInfos.getServiceInfo().get(i)).getBusinessKey());
            System.out.println("Name: " + TckCommon.ListToString(((ServiceInfo)serviceInfos.getServiceInfo().get(i)).getName()));
        }
    }

    public static void PrintBusinessDetails(List<BusinessEntity> businessDetail) {
        for (int i = 0; i < businessDetail.size(); ++i) {
            System.out.println("Business Detail - key: " + businessDetail.get(i).getBusinessKey());
            System.out.println("Name: " + TckCommon.ListToString(businessDetail.get(i).getName()));
            System.out.println("CategoryBag: " + TckCommon.CatBagToString(businessDetail.get(i).getCategoryBag()));
            TckCommon.PrintContacts(businessDetail.get(i).getContacts());
        }
    }

    public static void DeleteBusiness(String key, String authInfo, UDDIPublicationPortType publish) {
        if (key == null) {
            return;
        }
        try {
            DeleteBusiness db = new DeleteBusiness();
            db.setAuthInfo(authInfo);
            db.getBusinessKey().add(key);
            publish.deleteBusiness(db);
        }
        catch (Exception ex) {
            logger.warn((Object)("failed to delete business " + key + " " + ex.getMessage()));
            logger.debug((Object)("failed to delete business " + key + " " + ex.getMessage()), (Throwable)ex);
        }
    }

    public static void removeAllExistingSubscriptions(String authinfo, UDDISubscriptionPortType sub) {
        try {
            List subscriptions = sub.getSubscriptions(authinfo);
            DeleteSubscription ds = new DeleteSubscription();
            ds.setAuthInfo(authinfo);
            for (int i = 0; i < subscriptions.size(); ++i) {
                ds.getSubscriptionKey().add(((Subscription)subscriptions.get(i)).getSubscriptionKey());
            }
            if (!subscriptions.isEmpty()) {
                logger.info((Object)("Purging " + subscriptions.size() + " old subscriptions"));
                sub.deleteSubscription(ds);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"error clearing subscriptions", (Throwable)ex);
        }
    }

    public static boolean isDebug() {
        boolean serialize = false;
        try {
            if (System.getProperty("debug") != null && System.getProperty("debug").equalsIgnoreCase("true")) {
                serialize = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serialize;
    }

    public static String DumpAllServices(String authinfo, UDDIInquiryPortType inquiry) {
        StringBuilder sb = new StringBuilder();
        FindService fs = new FindService();
        fs.setAuthInfo(authinfo);
        fs.setFindQualifiers(new FindQualifiers());
        fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
        fs.getName().add(new Name("%", null));
        try {
            ServiceList findService = inquiry.findService(fs);
            if (findService.getServiceInfos() == null) {
                return "NO SERVICES RETURNED!";
            }
            for (int i = 0; i < findService.getServiceInfos().getServiceInfo().size(); ++i) {
                sb.append(((Name)((ServiceInfo)findService.getServiceInfos().getServiceInfo().get(i)).getName().get(0)).getValue()).append(" lang=").append(((Name)((ServiceInfo)findService.getServiceInfos().getServiceInfo().get(i)).getName().get(0)).getLang()).append(" ").append(((ServiceInfo)findService.getServiceInfos().getServiceInfo().get(i)).getServiceKey()).append(" ").append(((ServiceInfo)findService.getServiceInfos().getServiceInfo().get(i)).getBusinessKey()).append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            sb.append(ex.getMessage());
        }
        return sb.toString();
    }

    public static String DumpAllTModels(String authinfo, UDDIInquiryPortType inquriy) {
        StringBuilder sb = new StringBuilder();
        FindTModel fs = new FindTModel();
        fs.setAuthInfo(authinfo);
        fs.setFindQualifiers(new FindQualifiers());
        fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
        fs.setName(new Name("%", null));
        try {
            TModelList findService = inquriy.findTModel(fs);
            if (findService.getTModelInfos() == null) {
                return "NO TMODELS RETURNED!";
            }
            for (int i = 0; i < findService.getTModelInfos().getTModelInfo().size(); ++i) {
                sb.append(((TModelInfo)findService.getTModelInfos().getTModelInfo().get(i)).getName().getValue()).append(" lang=").append(((TModelInfo)findService.getTModelInfos().getTModelInfo().get(i)).getName().getLang()).append(" ").append(((TModelInfo)findService.getTModelInfos().getTModelInfo().get(i)).getTModelKey()).append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return sb.toString();
    }

    public static String DumpAllBusinesses(String authinfo, UDDIInquiryPortType inquriy) {
        StringBuilder sb = new StringBuilder();
        FindBusiness fs = new FindBusiness();
        fs.setAuthInfo(authinfo);
        fs.setFindQualifiers(new FindQualifiers());
        fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
        fs.getName().add(new Name("%", null));
        try {
            BusinessList findService = inquriy.findBusiness(fs);
            if (findService.getBusinessInfos() == null) {
                return "NO BUSINESSES RETURNED!";
            }
            for (int i = 0; i < findService.getBusinessInfos().getBusinessInfo().size(); ++i) {
                sb.append(((Name)((BusinessInfo)findService.getBusinessInfos().getBusinessInfo().get(i)).getName().get(0)).getValue()).append(" lang=").append(((Name)((BusinessInfo)findService.getBusinessInfos().getBusinessInfo().get(i)).getName().get(0)).getLang()).append(" ").append(((BusinessInfo)findService.getBusinessInfos().getBusinessInfo().get(i)).getBusinessKey()).append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return sb.toString();
    }
}

