/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.junit.Assert;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckBusinessService {
    public static final String NOTIFIER_SERVICE_XML = "uddi_data/subscriptionnotifier/businessService.xml";
    public static final String NOTIFIER_SERVICE_KEY = "uddi:uddi.joepublisher.com:notifierone";
    public static final String JOE_SERVICE_XML = "uddi_data/joepublisher/businessService.xml";
    public static final String JOE_SERVICE_KEY = "uddi:uddi.joepublisher.com:serviceone";
    public static final String JOE_SERVICE_XML_2 = "uddi_data/joepublisher/businessService2.xml";
    public static final String JOE_SERVICE_KEY_2 = "uddi:uddi.joepublisher.com:servicetwo";
    public static final String SAM_SERVICE_XML = "uddi_data/samsyndicator/businessService.xml";
    public static final String SAM_SERVICE_KEY = "uddi:www.samco.com:listingservice";
    public static final String RIFTSAW_PROCESS_XML = "uddi_data/bpel/riftsaw/WSDLPort.xml";
    public static final String RIFTSAW_PROCESS_KEY = "uddi:riftsaw.jboss.org:ticket-service";
    public static final String JOE_BINDING_KEY_1 = "uddi:uddi.joepublisher.com:bindingone";
    private Log logger = LogFactory.getLog(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;

    public TckBusinessService(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public String saveJoePublisherService(String authInfoJoe) {
        return this.saveService(authInfoJoe, JOE_SERVICE_XML, JOE_SERVICE_KEY);
    }

    public void updateJoePublisherService(String authInfoJoe, String description) {
        this.saveService(authInfoJoe, JOE_SERVICE_XML, JOE_SERVICE_KEY, description);
    }

    public void saveJoePublisherService2(String authInfoJoe) {
        this.saveService2(authInfoJoe, JOE_SERVICE_KEY, JOE_SERVICE_XML_2, JOE_SERVICE_KEY_2);
    }

    public void saveJoePublisherServices(String authInfoJoe, int businessInt, int numberOfCopies) {
        this.saveServices(authInfoJoe, businessInt, JOE_SERVICE_XML, JOE_SERVICE_KEY, numberOfCopies, "uddi:uddi.joepublisher.com:businessone");
    }

    public void deleteJoePublisherService(String authInfoJoe) {
        this.deleteService(authInfoJoe, JOE_SERVICE_KEY);
    }

    public void deleteJoePublisherService2(String authInfoJoe) {
        this.deleteService(authInfoJoe, JOE_SERVICE_KEY_2);
    }

    public void saveNotifierService(String authInfoJoe) {
        this.saveService(authInfoJoe, NOTIFIER_SERVICE_XML, NOTIFIER_SERVICE_KEY);
    }

    public void deleteNotifierService(String authInfoJoe) {
        this.deleteService(authInfoJoe, NOTIFIER_SERVICE_KEY);
    }

    public void deleteJoePublisherServices(String authInfoJoe, int businessInt, int numberOfCopies) {
        this.deleteServices(authInfoJoe, businessInt, JOE_SERVICE_KEY, numberOfCopies);
    }

    public void saveSamSyndicatorService(String authInfoSam) {
        this.saveService(authInfoSam, SAM_SERVICE_XML, SAM_SERVICE_KEY);
    }

    public void saveSamSyndicatorServices(String authInfoSam, int businessInt, int numberOfCopies) {
        this.saveServices(authInfoSam, businessInt, SAM_SERVICE_XML, SAM_SERVICE_KEY, numberOfCopies, "uddi:www.samco.com:samco");
    }

    public void deleteSamSyndicatorService(String authInfoSam) {
        this.deleteService(authInfoSam, SAM_SERVICE_KEY);
    }

    public void deleteSamSyndicatorServices(String authInfoSam, int businessInt, int numberOfCopies) {
        this.deleteServices(authInfoSam, businessInt, SAM_SERVICE_KEY, numberOfCopies);
    }

    public void saveServices(String authInfo, int businessInt, String serviceXML, String serviceKey, int numberOfCopies, String parentBusinessKey) {
        SaveService ss = null;
        try {
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)serviceXML, (String)"org.uddi.api_v3");
            String serviceName = ((Name)bsIn.getName().get(0)).getValue();
            String bindingKey = ((BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(0)).getBindingKey();
            for (int i = 0; i < numberOfCopies; ++i) {
                ss = new SaveService();
                ss.setAuthInfo(authInfo);
                ((Name)bsIn.getName().get(0)).setValue(serviceName + "-" + i);
                bsIn.setBusinessKey(parentBusinessKey);
                bsIn.setServiceKey(serviceKey + "-" + businessInt + "-" + i);
                ((BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(0)).setBindingKey(bindingKey + "-" + businessInt + "-" + i);
                ((BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(0)).setServiceKey(serviceKey + "-" + businessInt + "-" + i);
                ss.getBusinessService().add(bsIn);
                BindingTemplate bt = (BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(0);
                if (!bt.getServiceKey().equals(serviceKey + "-" + businessInt + "-" + i)) {
                    System.out.println("not the same");
                }
                this.publication.saveService(ss);
                this.logger.info((Object)("Add service with key " + bsIn.getServiceKey()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public String saveService(String authInfo, String serviceXML, String serviceKey) {
        return this.saveService(authInfo, serviceXML, serviceKey, null);
    }

    public String saveService(String authInfo, String serviceXML, String serviceKey, String description) {
        try {
            this.logger.info((Object)("saving service key " + serviceKey + " from " + serviceXML));
            SaveService ss = new SaveService();
            ss.setAuthInfo(authInfo);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)serviceXML, (String)"org.uddi.api_v3");
            if (description != null) {
                ((Description)bsIn.getDescription().get(0)).setValue("updated description");
            }
            ss.getBusinessService().add(bsIn);
            this.publication.saveService(ss);
            GetServiceDetail gs = new GetServiceDetail();
            gs.getServiceKey().add(serviceKey);
            ServiceDetail sd = this.inquiry.getServiceDetail(gs);
            List bsOutList = sd.getBusinessService();
            BusinessService bsOut = (BusinessService)bsOutList.get(0);
            junit.framework.Assert.assertEquals((String)bsIn.getServiceKey().toLowerCase(), (String)bsOut.getServiceKey());
            TckValidator.checkNames(bsIn.getName(), bsOut.getName());
            TckValidator.checkDescriptions(bsIn.getDescription(), bsOut.getDescription());
            TckValidator.checkBindingTemplates(bsIn.getBindingTemplates(), bsOut.getBindingTemplates());
            TckValidator.checkCategories(bsIn.getCategoryBag(), bsOut.getCategoryBag());
            if (bsOut.getBindingTemplates() != null && !bsOut.getBindingTemplates().getBindingTemplate().isEmpty()) {
                return ((BindingTemplate)bsOut.getBindingTemplates().getBindingTemplate().get(0)).getBindingKey();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
        return null;
    }

    public void saveService2(String authInfo, String serviceKey, String serviceXML2, String serviceKey2) {
        try {
            SaveService ss = new SaveService();
            ss.setAuthInfo(authInfo);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)serviceXML2, (String)"org.uddi.api_v3");
            ss.getBusinessService().add(bsIn);
            this.publication.saveService(ss);
            GetServiceDetail gs = new GetServiceDetail();
            gs.getServiceKey().add(serviceKey);
            gs.getServiceKey().add(serviceKey2);
            ServiceDetail sd = this.inquiry.getServiceDetail(gs);
            List bsOutList = sd.getBusinessService();
            int size = bsOutList.size();
            junit.framework.Assert.assertEquals((int)2, (int)size);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void deleteService(String authInfo, String serviceKey) {
        try {
            DeleteService ds = new DeleteService();
            ds.setAuthInfo(authInfo);
            ds.getServiceKey().add(serviceKey);
            this.publication.deleteService(ds);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void deleteServices(String authInfo, int businessInt, String serviceKey, int numberOfCopies) {
        try {
            for (int i = 0; i < numberOfCopies; ++i) {
                DeleteService ds = new DeleteService();
                ds.setAuthInfo(authInfo);
                ds.getServiceKey().add(serviceKey + "-" + businessInt + "-" + i);
                this.publication.deleteService(ds);
                this.logger.debug((Object)("Deleted Service with key " + businessInt + "-" + serviceKey + "-" + i));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

