/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.rmi.Remote;
import java.util.HashMap;
import org.apache.juddi.v3.client.transport.InVMTransport;
import org.apache.juddi.v3.client.transport.wrapper.Handler;
import org.apache.juddi.v3.client.transport.wrapper.RequestHandler;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UDDIInquiryService {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Handler> operations = new HashMap();

    public UDDIInquiryService() {
        this.operations.put("find_business", new Handler("findBusiness", FindBusiness.class));
        this.operations.put("find_service", new Handler("findService", FindService.class));
        this.operations.put("find_binding", new Handler("findBinding", FindBinding.class));
        this.operations.put("find_tModel", new Handler("findTModel", FindTModel.class));
        this.operations.put("find_relatedBusinesses", new Handler("findRelatedBusinesses", FindRelatedBusinesses.class));
        this.operations.put("get_businessDetail", new Handler("getBusinessDetail", GetBusinessDetail.class));
        this.operations.put("get_serviceDetail", new Handler("getServiceDetail", GetServiceDetail.class));
        this.operations.put("get_bindingDetail", new Handler("getBindingDetail", GetBindingDetail.class));
        this.operations.put("get_tModelDetail", new Handler("getTModelDetail", GetTModelDetail.class));
        this.operations.put("get_operationalInfo", new Handler("getOperationalInfo", GetOperationalInfo.class));
    }

    public void validateRequest(String operation, String version, Element uddiReq) throws UnsupportedOperationException {
        if (version == null) {
            throw new UnsupportedOperationException("version needs to be 3.0");
        }
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
    }

    public Node inquire(Element uddiReq) throws Exception {
        InVMTransport invmtransport = new InVMTransport();
        UDDIInquiryPortType inquiry = invmtransport.getUDDIInquiryService();
        RequestHandler requestHandler = new RequestHandler();
        requestHandler.setUddiReq(uddiReq);
        requestHandler.setPortType((Remote)inquiry);
        String operation = requestHandler.getOperation(uddiReq);
        Handler opHandler = this.operations.get(operation);
        requestHandler.setMethodName(opHandler.getMethodName());
        requestHandler.setOperationClass(opHandler.getParameter());
        String version = requestHandler.getVersion(uddiReq, operation);
        this.validateRequest(operation, version, uddiReq);
        Thread thread = new Thread((Runnable)requestHandler, "WorkThread");
        thread.start();
        thread.join();
        if (requestHandler.getException() != null) {
            throw new Exception(requestHandler.getException());
        }
        return requestHandler.getResponse();
    }
}

