/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHandler
implements Runnable {
    private static Log log = LogFactory.getLog(RequestHandler.class);
    private static DocumentBuilder docBuilder = null;
    private volatile String version;
    private volatile String operation;
    private volatile Element uddiReq;
    private volatile Node response;
    private volatile String exception;
    private volatile Remote portType;
    private volatile String methodName;
    private volatile Class<?> operationClass;

    public String getOperation(Element uddiReq) throws Exception {
        if (uddiReq == null) {
            throw new UnsupportedOperationException("UDDI Request is null");
        }
        String operation = uddiReq.getLocalName();
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
        this.setOperation(operation);
        return operation;
    }

    public String getVersion(Element uddiReq, String operation) throws Exception {
        String version = uddiReq.getAttribute("generic");
        if (version == null) {
            throw new UnsupportedOperationException("version needs to be 3.0");
        }
        this.setVersion(version);
        return version;
    }

    public static String getText(Element element) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        StringWriter sw = new StringWriter();
        trans.transform(new DOMSource(element), new StreamResult(sw));
        return new String(sw.toString());
    }

    @Override
    public void run() {
        try {
            String reqString = RequestHandler.getText(this.uddiReq);
            Object uddiReqObj = JAXBMarshaller.unmarshallFromString((String)reqString, (String)"org.uddi.api_v3");
            Method method = this.portType.getClass().getMethod(this.methodName, this.operationClass);
            Object result = method.invoke((Object)this.portType, uddiReqObj);
            DocumentBuilder docBuilder = this.getDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element element = document.createElement("temp");
            JAXBMarshaller.marshallToElement((Object)result, (String)"org.uddi.api_v3", (Element)element);
            document.appendChild(element.getFirstChild());
            this.setResponse(document);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            this.setException(ex.getMessage());
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            docBuilder = this.createDocumentBuilder();
        }
        return docBuilder;
    }

    private synchronized DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Node getResponse() {
        return this.response;
    }

    public void setResponse(Node response) {
        this.response = response;
    }

    public Element getUddiReq() {
        return this.uddiReq;
    }

    public void setUddiReq(Element uddiReq) {
        this.uddiReq = uddiReq;
    }

    public Remote getPortType() {
        return this.portType;
    }

    public void setPortType(Remote portType) {
        this.portType = portType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?> getOperationClass() {
        return this.operationClass;
    }

    public void setOperationClass(Class<?> operationClass) {
        this.operationClass = operationClass;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }
}

