/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.juddi.v3.client.config.ClientConfig;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class JAXWSTransport
implements Transport {
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public UDDIInquiryPortType getUDDIInquiryService() throws TransportException {
        if (this.inquiryService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.inquiry.url");
                QName qName = new QName("urn:uddi-org:api_v3_portType", "UDDIInquiryService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.inquiryService = (UDDIInquiryPortType)service.getPort(UDDIInquiryPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    public UDDISecurityPortType getUDDISecurityService() throws TransportException {
        if (this.securityService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.security.url");
                QName qName = new QName("urn:uddi-org:api_v3_portType", "UDDISecurityService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.securityService = (UDDISecurityPortType)service.getPort(UDDISecurityPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    public UDDIPublicationPortType getUDDIPublishService() throws TransportException {
        if (this.publishService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.publish.url");
                QName qName = new QName("urn:uddi-org:api_v3_portType", "UDDIPublishService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.publishService = (UDDIPublicationPortType)service.getPort(UDDIPublicationPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    public UDDISubscriptionPortType getUDDISubscriptionService() throws TransportException {
        if (this.subscriptionService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.subscription.url");
                QName qName = new QName("urn:uddi-org:sub_v3_portType", "UDDISubscriptionService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.subscriptionService = (UDDISubscriptionPortType)service.getPort(UDDISubscriptionPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService() throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.subscription.listener.url");
                QName qName = new QName("urn:uddi-org:subr_v3_portType", "UDDISubscriptionListenerService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.subscriptionListenerService = (UDDISubscriptionListenerPortType)service.getPort(UDDISubscriptionListenerPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    public UDDICustodyTransferPortType getUDDICustodyTransferService() throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.custodytransfer.url");
                QName qName = new QName("urn:uddi-org:custody_v3_portType", "UDDICustodyTransferService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.custodyTransferService = (UDDICustodyTransferPortType)service.getPort(UDDICustodyTransferPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    public JUDDIApiPortType getJUDDIApiService() throws TransportException {
        if (this.publisherService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.juddi.api.url");
                QName qName = new QName("urn:juddi-apache-org:api_v3_portType", "JUDDIApiService");
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.publisherService = (JUDDIApiPortType)service.getPort(JUDDIApiPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }
}

