/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import org.apache.juddi.v3.client.config.ClientConfig;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class InVMTransport
implements Transport {
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public UDDIInquiryPortType getUDDIInquiryService() throws TransportException {
        if (this.inquiryService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.inquiry.url");
                Class<?> c = Class.forName(endpointURL);
                this.inquiryService = (UDDIInquiryPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    public UDDISecurityPortType getUDDISecurityService() throws TransportException {
        if (this.securityService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.security.url");
                Class<?> c = Class.forName(endpointURL);
                this.securityService = (UDDISecurityPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    public UDDIPublicationPortType getUDDIPublishService() throws TransportException {
        if (this.publishService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.publish.url");
                Class<?> c = Class.forName(endpointURL);
                this.publishService = (UDDIPublicationPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    public UDDISubscriptionPortType getUDDISubscriptionService() throws TransportException {
        if (this.subscriptionService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.subscription.url");
                Class<?> c = Class.forName(endpointURL);
                this.subscriptionService = (UDDISubscriptionPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService() throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.subscription.listener.url");
                Class<?> c = Class.forName(endpointURL);
                this.subscriptionListenerService = (UDDISubscriptionListenerPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    public UDDICustodyTransferPortType getUDDICustodyTransferService() throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.custodytransfer.url");
                Class<?> c = Class.forName(endpointURL);
                this.custodyTransferService = (UDDICustodyTransferPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    public JUDDIApiPortType getJUDDIApiService() throws TransportException {
        if (this.publisherService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.juddi.api.url");
                Class<?> c = Class.forName(endpointURL);
                this.publisherService = (JUDDIApiPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }
}

