/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;

public class ClientConfig {
    private static final String UDDI_PROPERTIES = "uddi.properties";
    private Logger log = Logger.getLogger(ClientConfig.class);
    private Configuration config;
    private static ClientConfig instance = null;

    private ClientConfig() throws ConfigurationException {
        this.loadConfiguration();
    }

    private void loadConfiguration() throws ConfigurationException {
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemConfiguration());
        PropertiesConfiguration propConfig = new PropertiesConfiguration(UDDI_PROPERTIES);
        long refreshDelay = propConfig.getLong("uddi.configuration.reload.delay", 1000L);
        this.log.debug((Object)("Setting refreshDelay to " + refreshDelay));
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        propConfig.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        compositeConfig.addConfiguration((Configuration)propConfig);
        this.config = compositeConfig;
    }

    private static ClientConfig getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new ClientConfig();
        }
        return instance;
    }

    public static void reloadConfig() throws ConfigurationException {
        ClientConfig.getInstance().loadConfiguration();
    }

    public static Configuration getConfiguration() throws ConfigurationException {
        return ClientConfig.getInstance().config;
    }
}

