/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIKeyConvention;
import org.apache.juddi.v3.client.mapping.Topology;
import org.apache.juddi.v3.client.mapping.UDDIClientSubscriptionListenerImpl;
import org.apache.juddi.v3.client.mapping.UDDIServiceCacheMBean;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.mapping.wsdl.ReadWSDL;
import org.apache.juddi.v3.client.mapping.wsdl.WSDL2UDDI;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.Name;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;

public class UDDIServiceCache
implements UDDIServiceCacheMBean {
    public static final String UDDI_ORG_NS = "urn:uddi-org:v3_service";
    public static final String UDDI_CLIENT_SUBSCRIPTION_LISTENER = "UDDIClientSubscriptionListenerService";
    public static final QName SUBSCRIPTION_LISTENER_SERVICE_NAME = new QName("urn:uddi-org:v3_service", "UDDIClientSubscriptionListenerService");
    public static final String SUBSCRIPTION_LISTENER_PORT_NAME = "UDDIClientSubscriptionListenerImplPort";
    public static final String DEFAULT_SUBSCRIPTION_LISTENER_URL = "http://localhost:8080/subscriptionlistener_uddi_client";
    private Log log = LogFactory.getLog(this.getClass());
    private UDDIClerk clerk = null;
    private URLLocalizer urlLocalizer = null;
    private Properties properties = null;
    private String subscriptionKey = null;
    private Endpoint listenerEndpoint = null;
    private URL listenerServiceUrl = null;
    private ObjectName mbeanName = null;
    private ConcurrentHashMap<String, Topology> serviceLocationMap = new ConcurrentHashMap();

    public UDDIServiceCache() {
    }

    public UDDIServiceCache(UDDIClerk clerk) throws MalformedURLException {
        this.clerk = clerk;
        this.urlLocalizer = new URLLocalizerDefaultImpl(null);
        this.properties = clerk.getUDDINode().getProperties();
    }

    public UDDIServiceCache(UDDIClerk clerk, URL callbackBaseUrl) {
        this.clerk = clerk;
        this.urlLocalizer = new URLLocalizerDefaultImpl(callbackBaseUrl);
        this.properties = clerk.getUDDINode().getProperties();
    }

    public UDDIServiceCache(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws DatatypeConfigurationException, MalformedURLException, RemoteException, ConfigurationException, WSDLException, TransportException, Exception {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        Properties properties2 = clerk.getUDDINode().getProperties();
        if (properties2 != null) {
            properties2.putAll((Map<?, ?>)properties);
        } else {
            properties2 = properties;
        }
        this.properties = properties2;
    }

    public UDDIClerk getClerk() {
        return this.clerk;
    }

    public void publishAndRegisterHttpCallbackEndpoint() throws BindException {
        if (this.clerk != null && this.listenerEndpoint == null) {
            try {
                this.listenerServiceUrl = new URL(this.urlLocalizer.rewrite(new URL(DEFAULT_SUBSCRIPTION_LISTENER_URL)));
                WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this.clerk, this.urlLocalizer, this.properties);
                Definition wsdlDefinition = new ReadWSDL().readWSDL("org/apache/juddi/v3/client/mapping/UDDIClientSubscriptionListener.wsdl");
                String bindingKey = wsdl2UDDI.registerBusinessService(SUBSCRIPTION_LISTENER_SERVICE_NAME, SUBSCRIPTION_LISTENER_PORT_NAME, this.listenerServiceUrl, wsdlDefinition).getBindingKey();
                UDDIClientSubscriptionListenerImpl subscriptionListener = new UDDIClientSubscriptionListenerImpl(bindingKey, this);
                this.log.info((Object)("Bringing up a UDDIClientSubscriptionListenerImpl on Endpoint " + this.listenerServiceUrl.toExternalForm()));
                this.listenerEndpoint = Endpoint.create((Object)subscriptionListener);
                this.listenerEndpoint.publish(this.listenerServiceUrl.toExternalForm());
                this.log.info((Object)("Registering a CallbackSubscription to this endpoint using bindingKey " + bindingKey));
                this.registerSubscription(bindingKey);
            }
            catch (RuntimeException t) {
                this.listenerEndpoint = null;
                if (t.getCause() instanceof BindException) {
                    throw new BindException(t.getCause().getMessage());
                }
                throw t;
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot publish or register the CallbackEndpoint " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean hasListener() {
        if (this.listenerEndpoint == null) {
            return false;
        }
        return this.listenerEndpoint.isPublished();
    }

    public void registerAsMBean() {
        try {
            this.mbeanName = this.clerk != null ? new ObjectName("apache.juddi.client:type=UDDIServerCache-" + this.clerk.getManagerName() + "-" + this.clerk.getName()) : new ObjectName("apache.juddi.client:type=UDDIServerCache-" + this);
            MBeanServer mbeanServer = this.getMBeanServer();
            if (mbeanServer != null) {
                mbeanServer.registerMBean(this, this.mbeanName);
            } else {
                mbeanServer = null;
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Not able to register the UDDIServiceCache MBean " + e.getMessage()), (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.subscriptionKey != null) {
            this.clerk.unRegisterSubscription(this.subscriptionKey);
        }
        if (this.listenerEndpoint != null) {
            this.listenerEndpoint.stop();
            try {
                WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this.clerk, this.urlLocalizer, this.properties);
                wsdl2UDDI.unRegisterBusinessService(SUBSCRIPTION_LISTENER_SERVICE_NAME, SUBSCRIPTION_LISTENER_PORT_NAME, this.listenerServiceUrl);
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.mbeanName != null) {
            try {
                MBeanServer mbeanServer = this.getMBeanServer();
                if (mbeanServer != null) {
                    mbeanServer.unregisterMBean(this.mbeanName);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void removeAll() {
        this.log.info((Object)("Flushing the client side " + this.clerk.getManagerName() + " UDDIServiceCache "));
        for (String key : this.serviceLocationMap.keySet()) {
            this.serviceLocationMap.get(key);
        }
    }

    public void addService(String serviceKey, Topology topology) {
        this.serviceLocationMap.put(serviceKey, topology);
    }

    public Topology lookupService(String serviceKey) {
        return this.serviceLocationMap.get(serviceKey);
    }

    public void removeService(String serviceKey) {
        this.serviceLocationMap.remove(serviceKey);
    }

    public void registerSubscription(String bindingKey) throws DatatypeConfigurationException {
        String subscriptionKey = UDDIKeyConvention.getSubscriptionKey(this.properties);
        FindService findAllServices = new FindService();
        FindQualifiers qualifiers = new FindQualifiers();
        qualifiers.getFindQualifier().add("approximateMatch");
        findAllServices.setFindQualifiers(qualifiers);
        Name name = new Name();
        name.setValue("%");
        findAllServices.getName().add(name);
        SubscriptionFilter filter = new SubscriptionFilter();
        filter.setFindService(findAllServices);
        Subscription subscription = new Subscription();
        subscription.setSubscriptionFilter(filter);
        subscription.setBindingKey(bindingKey);
        subscription.setBrief(Boolean.valueOf(true));
        Duration oneMinute = DatatypeFactory.newInstance().newDuration("PT1M");
        subscription.setNotificationInterval(oneMinute);
        subscription.setSubscriptionKey(subscriptionKey);
        this.clerk.register(subscription);
        this.subscriptionKey = subscriptionKey;
    }

    public Map<String, Topology> getServiceCacheMap() {
        return this.serviceLocationMap;
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mbserver = null;
        ArrayList<MBeanServer> mbservers = MBeanServerFactory.findMBeanServer(null);
        if (mbservers.size() > 0) {
            mbserver = mbservers.get(0);
        }
        if (mbserver != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)"Found MBean server");
        } else {
            mbserver = ManagementFactory.getPlatformMBeanServer();
        }
        return mbserver;
    }

    @Override
    public int getServiceCacheSize() {
        return this.serviceLocationMap.size();
    }

    @Override
    public Set<String> getCacheEntries() {
        return this.serviceLocationMap.keySet();
    }

    @Override
    public void resetCache() {
        this.serviceLocationMap.clear();
    }
}

