/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.util.Properties;
import org.apache.juddi.v3.client.mapping.PolicyRoundRobin;
import org.apache.juddi.v3.client.mapping.Topology;

public class PolicyLocalFirst
extends PolicyRoundRobin {
    public static final String JUDDI_CLIENT_LOCAL = "juddi.client.local";
    public static final String DEFAULT_CLIENT_LOCAL = "localhost";
    private static String local;

    public PolicyLocalFirst(Properties properties) {
        super(properties);
        local = properties != null ? properties.getProperty(JUDDI_CLIENT_LOCAL, DEFAULT_CLIENT_LOCAL) : DEFAULT_CLIENT_LOCAL;
    }

    @Override
    public String select(Topology topology) {
        if (topology.getEprs().size() == 0) {
            return null;
        }
        if (topology.getHasLocal() == null) {
            int pointer = 0;
            topology.setHasLocal(Boolean.FALSE);
            for (String epr : topology.getEprs()) {
                if (epr.toLowerCase().contains(local.toLowerCase())) {
                    topology.setPointer(pointer);
                    topology.setHasLocal(Boolean.TRUE);
                    break;
                }
                ++pointer;
            }
        }
        if (topology.getHasLocal().booleanValue()) {
            return topology.getEprs().get(topology.getPointer());
        }
        return super.select(topology);
    }
}

