/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import javax.servlet.ServletContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIClientContainer;

public class WebHelper {
    public static final Log logger = LogFactory.getLog(WebHelper.class);
    public static final String UDDI_CLIENT_NAME = "uddi.client.name";
    public static final String UDDI_CLIENT_CONFIG_FILE = "uddi.client.config.file";
    public static final String JUDDI_CLIENT_NAME = "juddi.client.name";
    public static final String JUDDI_CLIENT_TRANSPORT = "juddi.client.transport";

    public static UDDIClient getUDDIClient(ServletContext servletContext) throws ConfigurationException {
        String clientConfigFile;
        if (servletContext.getAttribute(JUDDI_CLIENT_NAME) != null) {
            String clientName = String.valueOf(servletContext.getAttribute(JUDDI_CLIENT_NAME));
            return UDDIClientContainer.getUDDIClient(clientName);
        }
        String clientName = servletContext.getInitParameter(UDDI_CLIENT_NAME);
        if (clientName != null) {
            try {
                UDDIClient client = UDDIClientContainer.getUDDIClient(clientName);
                logger.info((Object)("Client " + clientName + " was already started."));
                servletContext.setAttribute(JUDDI_CLIENT_NAME, (Object)clientName);
                return client;
            }
            catch (ConfigurationException ce) {
                logger.debug((Object)("Client " + clientName + " is not yet started."));
            }
        }
        if ((clientConfigFile = servletContext.getInitParameter(UDDI_CLIENT_CONFIG_FILE)) == null) {
            clientConfigFile = "META-INF/uddi.xml";
        }
        logger.info((Object)("Reading the clientName from the clientConfig file " + clientConfigFile));
        UDDIClient client = new UDDIClient(clientConfigFile);
        if (clientConfigFile == null && client.getName() == null) {
            logger.warn((Object)"Deprecated, client name set to 'default', however it should be provided in the uddi.xml");
            clientName = "default";
        }
        if (client.getName() == null) {
            throw new ConfigurationException("A client name needs to be specified in the client config file.");
        }
        logger.info((Object)("Starting Client " + client.getName() + "..."));
        clientName = client.getName();
        client.start();
        servletContext.setAttribute(JUDDI_CLIENT_NAME, (Object)clientName);
        return client;
    }
}

