/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClient;

public class UDDIClientContainer {
    private static Log log = LogFactory.getLog(UDDIClientContainer.class);
    private static Map<String, UDDIClient> clients = new HashMap<String, UDDIClient>();

    public static UDDIClient getUDDIClient(String clientName) throws ConfigurationException {
        if (clientName != null) {
            if (clients.containsKey(clientName)) {
                return clients.get(clientName);
            }
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = clients.keySet().iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            throw new ConfigurationException("No client by name " + clientName + " was found.  Please check your client uddi.xml files, and make sure this client was started. Available clients: " + sb.toString());
        }
        throw new IllegalArgumentException("clientName is a required argument");
    }

    public static boolean addClient(UDDIClient manager) {
        if (!clients.containsKey(manager.getClientConfig().getClientName())) {
            clients.put(manager.getClientConfig().getClientName(), manager);
            return true;
        }
        return false;
    }

    public static void removeClerkManager(String clientName) throws ConfigurationException {
        if (clients.containsKey(clientName)) {
            clients.remove(clientName);
        } else if (clients.size() == 1 && clientName == null) {
            String name = clients.keySet().iterator().next();
            log.info((Object)("Removing " + name + " from UDDIClient."));
            clients.remove(name);
        } else {
            throw new ConfigurationException("Could not remove UDDIClient for name " + clientName);
        }
    }

    public static boolean contains(String name) {
        return clients.containsKey(name);
    }
}

