/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Definition;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.mapping.wsdl.ReadWSDL;
import org.apache.juddi.v3.client.mapping.wsdl.WSDL2UDDI;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class WsdlImport {
    private Properties properties = new Properties();
    private String wsdlURL = null;
    private UDDISecurityPortType security = null;
    private UDDIPublicationPortType publish = null;

    public static void main(String[] args) throws Exception {
        new WsdlImport().fire("http://svn.apache.org/repos/asf/juddi/trunk/uddi-ws/src/main/resources/juddi_api_v1.wsdl", null, null, null);
    }

    public void fire(String pathOrURL, String businessKey, String token, Transport transport) throws Exception {
        int i;
        if (transport == null) {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            transport = clerkManager.getTransport();
        }
        this.security = transport.getUDDISecurityService();
        this.publish = transport.getUDDIPublishService();
        if (token == null) {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID("uddi");
            getAuthTokenRoot.setCred("uddi");
            AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
            token = rootAuthToken.getAuthInfo();
        }
        String domain = "localhost";
        int port = 80;
        if (pathOrURL.startsWith("http")) {
            URL url = new URL(pathOrURL);
            domain = url.getHost();
            port = url.getPort();
            if (port == -1) {
                if (pathOrURL.startsWith("https://")) {
                    port = 443;
                }
                if (pathOrURL.startsWith("http://")) {
                    port = 80;
                }
            }
        }
        TModel keygen = UDDIClerk.createKeyGenator((String)("uddi:" + domain + ":keygenerator"), (String)domain, (String)"en");
        SaveTModel stm = new SaveTModel();
        stm.setAuthInfo(token);
        stm.getTModel().add(keygen);
        System.out.println("Saving key gen " + keygen.getTModelKey());
        this.publish.saveTModel(stm);
        System.out.println("Saved!");
        ReadWSDL rw = new ReadWSDL();
        Definition wsdlDefinition = null;
        wsdlDefinition = pathOrURL.startsWith("http") ? rw.readWSDL(new URL(pathOrURL)) : rw.readWSDL(pathOrURL);
        if (wsdlDefinition == null) {
            System.out.println("There was an error parsing the WSDL!");
            return;
        }
        this.properties.put("keyDomain", domain);
        this.properties.put("businessName", domain);
        this.properties.put("serverName", domain);
        this.properties.put("serverPort", (Object)port);
        this.wsdlURL = wsdlDefinition.getDocumentBaseURI();
        WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(null, (URLLocalizer)new URLLocalizerDefaultImpl(), this.properties);
        BusinessServices businessServices = wsdl2UDDI.createBusinessServices(wsdlDefinition);
        Map portTypes = wsdlDefinition.getAllPortTypes();
        Set portTypeTModels = wsdl2UDDI.createWSDLPortTypeTModels(this.wsdlURL, portTypes);
        Map allBindings = wsdlDefinition.getAllBindings();
        Set createWSDLBindingTModels = wsdl2UDDI.createWSDLBindingTModels(this.wsdlURL, allBindings);
        stm = new SaveTModel();
        stm.setAuthInfo(token);
        TModel[] tmodels = portTypeTModels.toArray(new TModel[0]);
        for (i = 0; i < tmodels.length; ++i) {
            stm.getTModel().add(tmodels[i]);
        }
        tmodels = createWSDLBindingTModels.toArray(new TModel[0]);
        for (i = 0; i < tmodels.length; ++i) {
            stm.getTModel().add(tmodels[i]);
        }
        System.out.println(new PrintUDDI().print((Object)stm));
        System.out.println("Saving " + stm.getTModel().size() + " tModels");
        this.publish.saveTModel(stm);
        System.out.println("Saved!");
        if (businessKey == null || businessKey.length() == 0) {
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(token);
            BusinessEntity be = new BusinessEntity();
            be.setBusinessKey(((BusinessService)businessServices.getBusinessService().get(0)).getBusinessKey());
            be.getName().add(new Name());
            ((Name)be.getName().get(0)).setValue(domain);
            ((Name)be.getName().get(0)).setLang("en");
            sb.getBusinessEntity().add(be);
            BusinessDetail saveBusiness = this.publish.saveBusiness(sb);
            businessKey = ((BusinessEntity)saveBusiness.getBusinessEntity().get(0)).getBusinessKey();
            System.out.println("new business created key= " + businessKey);
        }
        SaveService ss = new SaveService();
        ss.setAuthInfo(token);
        for (int i2 = 0; i2 < businessServices.getBusinessService().size(); ++i2) {
            ((BusinessService)businessServices.getBusinessService().get(i2)).setBusinessKey(businessKey);
            ss.getBusinessService().add(businessServices.getBusinessService().get(i2));
        }
        System.out.println("Here's our new service(s): " + new PrintUDDI().print((Object)ss));
        this.publish.saveService(ss);
        System.out.println("Saved!");
    }
}

