/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.List;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class UddiSubscriptionManagement {
    private UDDISubscriptionPortType uddiSubscriptionService = null;
    private UDDIClerk clerk = null;
    private UDDIClient client = null;
    PrintUDDI<Subscription> p = new PrintUDDI();

    public UddiSubscriptionManagement() {
        try {
            this.client = new UDDIClient("META-INF/simple-publish-uddi.xml");
            this.clerk = this.client.getClerk("default");
            Transport transport = this.client.getTransport();
            this.uddiSubscriptionService = transport.getUDDISubscriptionService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UddiSubscriptionManagement(Transport transport) {
        try {
            this.uddiSubscriptionService = transport.getUDDISubscriptionService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        UddiSubscriptionManagement sp = new UddiSubscriptionManagement();
        sp.printSubscriptions(null);
    }

    public void printSubscriptions(String authtoken) throws Exception {
        if (authtoken == null) {
            authtoken = this.clerk.getAuthToken();
        }
        List subscriptions = this.uddiSubscriptionService.getSubscriptions(authtoken);
        System.out.println(subscriptions.size() + " subscriptions found");
        for (int i = 0; i < subscriptions.size(); ++i) {
            System.out.println("_____________________________________");
            System.out.println(this.p.print(subscriptions.get(i)));
        }
    }

    public void deleteSubscription(String authtoken, String key) throws Exception {
        if (authtoken == null) {
            authtoken = this.clerk.getAuthToken();
        }
        if (key == null) {
            System.out.println("No key specified!");
            return;
        }
        DeleteSubscription ds = new DeleteSubscription();
        ds.setAuthInfo(authtoken);
        ds.getSubscriptionKey().add(key);
        this.uddiSubscriptionService.deleteSubscription(ds);
        System.out.println("Deleted!");
    }

    public void deleteAllSubscriptions(String authtoken) throws Exception {
        if (authtoken == null) {
            authtoken = this.clerk.getAuthToken();
        }
        List subscriptions = this.uddiSubscriptionService.getSubscriptions(authtoken);
        System.out.println(subscriptions.size() + " subscriptions found");
        for (int i = 0; i < subscriptions.size(); ++i) {
            System.out.println("_____________________________________");
            System.out.println(((Subscription)subscriptions.get(i)).getSubscriptionKey());
            DeleteSubscription ds = new DeleteSubscription();
            ds.setAuthInfo(authtoken);
            ds.getSubscriptionKey().add(((Subscription)subscriptions.get(i)).getSubscriptionKey());
            this.uddiSubscriptionService.deleteSubscription(ds);
            System.out.println("Deleted!");
        }
    }
}

