/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiRelatedBusinesses {
    private UDDISecurityPortType security = null;
    private UDDIPublicationPortType publish = null;

    public UddiRelatedBusinesses() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.publish = transport.getUDDIPublishService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fire(String businessKey, String authInfo, String businessKey1, String authInfo1, String relationship) throws Exception {
        try {
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTimeInMillis(System.currentTimeMillis());
            Holder x = new Holder();
            PublisherAssertion pa = new PublisherAssertion();
            pa.setFromKey(businessKey);
            pa.setToKey(businessKey1);
            pa.setKeyedReference(new KeyedReference());
            pa.getKeyedReference().setKeyName("Subsidiary");
            pa.getKeyedReference().setKeyValue(relationship);
            pa.getKeyedReference().setTModelKey("uddi:uddi.org:relationships");
            x.value = new ArrayList();
            ((List)x.value).add(pa);
            this.publish.setPublisherAssertions(authInfo, x);
            x = new Holder();
            pa = new PublisherAssertion();
            pa.setFromKey(businessKey);
            pa.setToKey(businessKey1);
            pa.setKeyedReference(new KeyedReference());
            pa.getKeyedReference().setKeyName("Subsidiary");
            pa.getKeyedReference().setKeyValue(relationship);
            pa.getKeyedReference().setTModelKey("uddi:uddi.org:relationships");
            x.value = new ArrayList();
            ((List)x.value).add(pa);
            this.publish.setPublisherAssertions(authInfo1, x);
            System.out.println("Success!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        UddiRelatedBusinesses sp = new UddiRelatedBusinesses();
        GetAuthToken getAuthTokenRoot = new GetAuthToken();
        getAuthTokenRoot.setUserID("root");
        getAuthTokenRoot.setCred("root");
        AuthToken rootAuthToken = sp.security.getAuthToken(getAuthTokenRoot);
        System.out.println("root AUTHTOKEN = don't log auth tokens!");
        BusinessEntity rootbiz = sp.createBusiness("root");
        getAuthTokenRoot = new GetAuthToken();
        getAuthTokenRoot.setUserID("uddi");
        getAuthTokenRoot.setCred("uddi");
        AuthToken uddiAuthToken = sp.security.getAuthToken(getAuthTokenRoot);
        System.out.println("uddi AUTHTOKEN = don't log auth tokens!");
        BusinessEntity uddibiz = sp.createBusiness("uddi");
        SaveBusiness sb = new SaveBusiness();
        sb.setAuthInfo(uddiAuthToken.getAuthInfo());
        sb.getBusinessEntity().add(uddibiz);
        BusinessDetail uddibize = sp.publish.saveBusiness(sb);
        sb = new SaveBusiness();
        sb.setAuthInfo(rootAuthToken.getAuthInfo());
        sb.getBusinessEntity().add(rootbiz);
        BusinessDetail rootbize = sp.publish.saveBusiness(sb);
        sp.fire(((BusinessEntity)rootbize.getBusinessEntity().get(0)).getBusinessKey(), rootAuthToken.getAuthInfo(), ((BusinessEntity)uddibize.getBusinessEntity().get(0)).getBusinessKey(), uddiAuthToken.getAuthInfo(), "parent-child");
    }

    private BusinessEntity createBusiness(String user) {
        BusinessEntity be = new BusinessEntity();
        be.getName().add(new Name(user + "'s business", null));
        return be;
    }
}

