/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiKeyGenerator {
    private UDDISecurityPortType security = null;
    private UDDIPublicationPortType publish = null;

    public UddiKeyGenerator() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.publish = transport.getUDDIPublishService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fire(String token, String domain) {
        try {
            if (token == null) {
                GetAuthToken getAuthTokenRoot = new GetAuthToken();
                getAuthTokenRoot.setUserID("uddi");
                getAuthTokenRoot.setCred("uddi");
                AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
                System.out.println("uddi AUTHTOKEN = don't log auth tokens!");
                token = rootAuthToken.getAuthInfo();
            }
            SaveTModel st = new SaveTModel();
            st.setAuthInfo(token);
            st.getTModel().add(UDDIClerk.createKeyGenator((String)domain, (String)domain, (String)"en"));
            TModelDetail saveTModel = this.publish.saveTModel(st);
            System.out.println("Saved!  key = " + ((TModel)saveTModel.getTModel().get(0)).getTModelKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiKeyGenerator sp = new UddiKeyGenerator();
        sp.fire(null, "www.juddi.is.cool.org");
    }
}

