/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXB;
import org.apache.juddi.v3.client.cryptor.DigSigUtil;
import org.apache.juddi.v3.client.cryptor.XmlUtils;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModel;

public class UddiDigitalSignatureFile {
    public void fire(String fileIn, String fileOut, UddiType type) {
        try {
            System.out.println("WARN - All previous signatures will be removed!");
            if (fileIn == null || fileOut == null || type == null) {
                System.out.print("Input file: ");
                fileIn = System.console().readLine();
                System.out.print("Out file: ");
                fileOut = System.console().readLine();
                System.out.println();
                for (int i = 0; i < UddiType.values().length; ++i) {
                    System.out.println("[" + i + "] " + UddiType.values()[i].toString());
                }
                System.out.print("UDDI Type: ");
                String t = System.console().readLine();
                type = UddiType.values()[Integer.parseInt(t)];
            }
            DigSigUtil ds = null;
            ds = new DigSigUtil();
            ds.put("keyStorePath", "keystore.jks");
            ds.put("keyStoreType", "JKS");
            ds.put("filePassword", "Test");
            ds.put("keyAlias", "Test");
            ds.put("BASE64", "true");
            ds.put("SERIAL", "true");
            ds.put("SUBJECTDN", "true");
            ds.put("trustStorePath", "truststore.jks");
            ds.put("trustStoreType", "JKS");
            ds.put("trustStorePassword", "Test");
            FileInputStream fis = new FileInputStream(fileIn);
            Class<BindingTemplate> expectedType = null;
            switch (type) {
                case Binding: {
                    expectedType = BindingTemplate.class;
                    break;
                }
                case Business: {
                    expectedType = BusinessEntity.class;
                    break;
                }
                case PublisherAssertion: {
                    expectedType = PublisherAssertion.class;
                    break;
                }
                case Service: {
                    expectedType = BusinessService.class;
                    break;
                }
                case TModel: {
                    expectedType = TModel.class;
                }
            }
            Object be = XmlUtils.unmarshal((InputStream)fis, expectedType);
            fis.close();
            fis = null;
            switch (type) {
                case Binding: {
                    ((BindingTemplate)be).getSignature().clear();
                    break;
                }
                case Business: {
                    ((BusinessEntity)be).getSignature().clear();
                    break;
                }
                case PublisherAssertion: {
                    ((PublisherAssertion)be).getSignature().clear();
                    break;
                }
                case Service: {
                    ((BusinessService)be).getSignature().clear();
                    break;
                }
                case TModel: {
                    ((TModel)be).getSignature().clear();
                }
            }
            System.out.println("signing");
            Object signUDDI_JAXBObject = ds.signUddiEntity(be);
            System.out.println("signed");
            DigSigUtil.JAXB_ToStdOut((Object)signUDDI_JAXBObject);
            System.out.println("verifing");
            AtomicReference msg = new AtomicReference();
            boolean verifySigned_UDDI_JAXB_Object = ds.verifySignedUddiEntity(signUDDI_JAXBObject, msg);
            if (verifySigned_UDDI_JAXB_Object) {
                System.out.println("signature validation passed (expected)");
                FileOutputStream fos = new FileOutputStream(fileOut);
                JAXB.marshal((Object)signUDDI_JAXBObject, (OutputStream)fos);
                fos.close();
            } else {
                System.out.println("signature validation failed (not expected)");
            }
            System.out.println((String)msg.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum UddiType {
        Business,
        Service,
        Binding,
        TModel,
        PublisherAssertion;

    }
}

