/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.io.OutputStream;
import javax.xml.bind.JAXB;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.ext.wsdm.WSDMQosConstants;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelBag;
import org.uddi.v3_service.UDDIInquiryPortType;

public class SearchByQos {
    private UDDIInquiryPortType inquiry;

    public void doFindService(String token, Transport transport) throws Exception {
        this.inquiry = transport.getUDDIInquiryService();
        String uddi = token;
        ServiceList after = this.getServiceList(uddi);
        if (after.getServiceInfos() == null || after.getServiceInfos().getServiceInfo() == null) {
            System.out.println("no services returned!");
            return;
        }
        System.out.println(after.getServiceInfos().getServiceInfo().size() + " services returned!");
        JAXB.marshal((Object)after, (OutputStream)System.out);
    }

    public void doFindBinding(String token, Transport transport) throws Exception {
        this.inquiry = transport.getUDDIInquiryService();
        String uddi = token;
        BindingDetail after = this.getBindingList(uddi);
        if (after.getBindingTemplate() == null) {
            System.out.println("no bindings returned!");
            return;
        }
        PrintUDDI p = new PrintUDDI();
        System.out.println(p.print((Object)after));
    }

    public void doFindBusiness(String token, Transport transport) throws Exception {
        this.inquiry = transport.getUDDIInquiryService();
        String uddi = token;
        BusinessList after2 = this.getBusinessList(uddi);
        PrintUDDI p2 = new PrintUDDI();
        System.out.println(p2.print((Object)after2));
    }

    private BusinessList getBusinessList(String token) throws Exception {
        FindBusiness fb = new FindBusiness();
        fb.setAuthInfo(token);
        FindQualifiers fq = new FindQualifiers();
        fq.getFindQualifier().add("approximateMatch");
        fq.getFindQualifier().add("orAllKeys");
        fb.setFindQualifiers(fq);
        fb.getName().add(new Name("%", null));
        fb.setTModelBag(new TModelBag());
        fb.getTModelBag().getTModelKey().addAll(WSDMQosConstants.getAllQOSKeys());
        return this.inquiry.findBusiness(fb);
    }

    private ServiceList getServiceList(String token) throws Exception {
        FindService fb = new FindService();
        fb.setAuthInfo(token);
        FindQualifiers fq = new FindQualifiers();
        fq.getFindQualifier().add("approximateMatch");
        fq.getFindQualifier().add("orAllKeys");
        fb.setFindQualifiers(fq);
        fb.getName().add(new Name("%", null));
        fb.setTModelBag(new TModelBag());
        fb.getTModelBag().getTModelKey().addAll(WSDMQosConstants.getAllQOSKeys());
        return this.inquiry.findService(fb);
    }

    private BindingDetail getBindingList(String token) throws Exception {
        FindBinding fb = new FindBinding();
        fb.setAuthInfo(token);
        fb.setTModelBag(new TModelBag());
        fb.getTModelBag().getTModelKey().addAll(WSDMQosConstants.getAllQOSKeys());
        fb.setFindQualifiers(new FindQualifiers());
        fb.getFindQualifiers().getFindQualifier().add("uddi:uddi.org:findqualifier:orallkeys");
        return this.inquiry.findBinding(fb);
    }
}

